/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.service.impl;

import io.github.ecsoya.fabric.FabricPagination;
import io.github.ecsoya.fabric.FabricPaginationQuery;
import io.github.ecsoya.fabric.FabricQuery;
import io.github.ecsoya.fabric.FabricQueryRequest;
import io.github.ecsoya.fabric.FabricQueryResponse;
import io.github.ecsoya.fabric.FabricRequest;
import io.github.ecsoya.fabric.FabricResponse;
import io.github.ecsoya.fabric.bean.FabricBlock;
import io.github.ecsoya.fabric.bean.FabricHistory;
import io.github.ecsoya.fabric.bean.FabricIdentity;
import io.github.ecsoya.fabric.bean.IFabricIdentityObject;
import io.github.ecsoya.fabric.bean.IFabricObject;
import io.github.ecsoya.fabric.chaincode.FunctionType;
import io.github.ecsoya.fabric.config.FabricContext;
import io.github.ecsoya.fabric.json.FabricWrapper;
import io.github.ecsoya.fabric.service.IFabricCommonService;
import io.github.ecsoya.fabric.service.impl.AbstractFabricBaseService;
import io.github.ecsoya.fabric.utils.FabricUtil;
import io.github.ecsoya.fabric.utils.TypeResolver;
import java.util.List;

public abstract class AbstractFabricCommonService<T extends IFabricObject>
extends AbstractFabricBaseService
implements IFabricCommonService<T> {
    private Class<T> genericType;
    private String fabricType;

    public AbstractFabricCommonService(FabricContext fabricContext) {
        super(fabricContext);
    }

    protected Class<T> getGenericType() {
        if (this.genericType == null) {
            this.genericType = TypeResolver.resolveRawArgument(IFabricCommonService.class, this.getClass());
        }
        return this.genericType;
    }

    protected String getFabricType() {
        if (this.fabricType == null) {
            this.fabricType = FabricUtil.resolveFabricType(this.getGenericType());
        }
        return this.fabricType;
    }

    protected abstract FabricRequest newRequest(String var1, String ... var2);

    protected abstract <X> FabricQueryRequest<X> newQueryRequest(Class<X> var1, String var2, String ... var3);

    protected String getFunction(FunctionType type) {
        return this.fabricContext.getFunction(type);
    }

    @Override
    public FabricResponse create(T object) {
        FabricWrapper wrapper = new FabricWrapper(object);
        if (!wrapper.isValid()) {
            return FabricResponse.fail("Invalid arguments");
        }
        String key = wrapper.getKey();
        String value = wrapper.getValue();
        String type = wrapper.getType();
        return this.execute(this.newRequest(this.getFunction(FunctionType.FUNCTION_CREATE), type, key, value));
    }

    @Override
    public FabricResponse update(T object) {
        FabricWrapper wrapper = new FabricWrapper(object);
        if (!wrapper.isValid()) {
            return FabricResponse.fail("Invalid arguments");
        }
        String key = wrapper.getKey();
        String value = wrapper.getValue();
        String type = wrapper.getType();
        return this.execute(this.newRequest(this.getFunction(FunctionType.FUNCTION_UPDATE), type, key, value));
    }

    @Override
    public FabricResponse delete(String key) {
        if (key == null) {
            return FabricResponse.fail("Invalid key for deleting");
        }
        return this.execute(this.newRequest(this.getFunction(FunctionType.FUNCTION_DELETE), this.getFabricType(), key));
    }

    @Override
    public FabricQueryResponse<T> get(String key) {
        FabricQueryResponse<FabricBlock> blockRes;
        IFabricObject t;
        if (key == null) {
            return FabricQueryResponse.failure("Invalid key of query.");
        }
        FabricQueryResponse<T> response = this.query(this.newQueryRequest(this.getGenericType(), this.getFunction(FunctionType.FUNCTION_GET), this.getFabricType(), key));
        if (response.isOk(true) && (t = (IFabricObject)response.data) instanceof IFabricIdentityObject && (blockRes = this.block(t.getId())).isOk(true)) {
            ((IFabricIdentityObject)t).setIdentity((FabricIdentity)blockRes.data);
        }
        return response;
    }

    @Override
    public FabricQueryResponse<List<T>> query(FabricQuery query) {
        if (query == null) {
            return FabricQueryResponse.failure("Invalid arguments");
        }
        String selector = query.selector();
        FabricQueryResponse<List<T>> result = this.queryMany(this.newQueryRequest(this.getGenericType(), this.getFunction(FunctionType.FUNCTION_QUERY), selector));
        if (result.isOk(true)) {
            ((List)result.data).forEach(t -> {
                FabricQueryResponse<FabricBlock> blockRes;
                if (t instanceof IFabricIdentityObject && (blockRes = this.block(t.getId())).isOk(true)) {
                    ((IFabricIdentityObject)t).setIdentity((FabricIdentity)blockRes.data);
                }
            });
        }
        return result;
    }

    @Override
    public FabricPagination<T> pagination(FabricPaginationQuery<T> query) {
        FabricPagination<T> pagination = FabricPagination.create(query);
        if (query == null) {
            return pagination;
        }
        String selector = query.selector();
        FabricQueryResponse<List<T>> response = this.queryMany(this.newQueryRequest(this.getGenericType(), this.getFunction(FunctionType.FUNCTION_QUERY), selector, Integer.toString(query.getPageSize()), query.getBookmark()));
        if (response.isOk(true)) {
            ((List)response.data).forEach(t -> {
                FabricQueryResponse<FabricBlock> blockRes;
                if (t instanceof IFabricIdentityObject && (blockRes = this.block(t.getId())).isOk(true)) {
                    ((IFabricIdentityObject)t).setIdentity((FabricIdentity)blockRes.data);
                }
            });
            pagination.setData((List)response.data);
        }
        if (response.metadata != null) {
            pagination.setBookmark(response.metadata.getBookmark());
            pagination.setRecordsCount(response.metadata.getRecordsCount());
            pagination.updateTotalRecords();
        }
        return pagination;
    }

    @Override
    public FabricQueryResponse<List<T>> list() {
        return this.queryMany(this.newQueryRequest(this.getGenericType(), this.getFunction(FunctionType.FUNCTION_LIST), new String[0]));
    }

    @Override
    public FabricQueryResponse<List<FabricHistory>> history(String key) {
        if (key == null) {
            return FabricQueryResponse.failure("Invalid key of history");
        }
        return this.queryMany(this.newQueryRequest(FabricHistory.class, this.getFunction(FunctionType.FUNCTION_HISTORY), this.getFabricType(), key));
    }

    @Override
    public FabricQueryResponse<Number> count(FabricQuery query) {
        if (query == null) {
            return FabricQueryResponse.failure("Invalid arguments");
        }
        String selector = query.selector();
        return this.query(this.newQueryRequest(Number.class, this.getFunction(FunctionType.FUNCTION_COUNT), selector));
    }

    @Override
    public FabricQueryResponse<Boolean> exists(FabricQuery query) {
        if (query == null) {
            return FabricQueryResponse.failure("Invalid arguments");
        }
        String selector = query.selector();
        return this.query(this.newQueryRequest(Boolean.class, this.getFunction(FunctionType.FUNCTION_EXISTS), selector));
    }

    @Override
    public FabricQueryResponse<FabricBlock> block(String key) {
        FabricQueryResponse<List<FabricHistory>> historyRes = this.history(key);
        if (historyRes.isOk(true)) {
            List histories = (List)historyRes.data;
            long blockHeight = 0L;
            FabricBlock result = null;
            for (FabricHistory fabricHistory : histories) {
                FabricBlock block = fabricHistory.getBlock();
                if (block == null) continue;
                if (result == null) {
                    result = block;
                    blockHeight = block.getBlockNumber();
                    continue;
                }
                if (block.getBlockNumber() >= blockHeight) continue;
                result = block;
            }
            if (result != null) {
                return FabricQueryResponse.success(result);
            }
            return FabricQueryResponse.failure("No block found for key: " + key);
        }
        return FabricQueryResponse.failure("Could not get block for key: " + key + " with error: " + historyRes.errorMsg);
    }
}

