/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.github.ecsoya.fabric.json.FabricGsonDeserializeExclusionStrategy;
import io.github.ecsoya.fabric.json.FabricGsonNamingStrategy;
import io.github.ecsoya.fabric.json.FabricGsonSerializeExclusionStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FabricGson {
    private static Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setDateFormat(1).setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).setVersion(1.0).addSerializationExclusionStrategy((ExclusionStrategy)FabricGsonSerializeExclusionStrategy.INSTANCE).addDeserializationExclusionStrategy((ExclusionStrategy)FabricGsonDeserializeExclusionStrategy.INSTANCE).setFieldNamingStrategy((FieldNamingStrategy)new FabricGsonNamingStrategy()).create();

    private FabricGson() {
    }

    public static String stringify(Object object) {
        JsonElement element;
        if (object == null) {
            return null;
        }
        if (object instanceof JsonElement && (element = (JsonElement)object).isJsonPrimitive()) {
            return element.getAsString();
        }
        return gson.toJson(object);
    }

    public static JsonElement json(Object object) {
        if (object == null) {
            return null;
        }
        return gson.toJsonTree(object);
    }

    public static <T> T build(String json, Class<T> type) {
        if (json == null) {
            return null;
        }
        return (T)gson.fromJson(json, type);
    }

    public static <T> T build(JsonElement json, Class<T> type) {
        if (json == null) {
            return null;
        }
        return (T)gson.fromJson(json, type);
    }

    public static <T> List<T> buildList(String json, Class<T> type) {
        JsonElement element = JsonParser.parseString((String)json);
        return FabricGson.buildList(element, type);
    }

    public static <T> List<T> buildList(JsonElement element, Class<T> type) {
        if (element == null || !element.isJsonArray()) {
            return Collections.emptyList();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        JsonArray array = element.getAsJsonArray();
        for (JsonElement child : array) {
            Object value = null;
            value = child.isJsonObject() && child.getAsJsonObject().has("Key") && child.getAsJsonObject().has("Record") ? gson.fromJson(child.getAsJsonObject().get("Record"), type) : gson.fromJson(child, type);
            results.add(value);
        }
        return results;
    }
}

