/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.bean;

import io.github.ecsoya.fabric.bean.FabricTransactionRW;
import java.util.ArrayList;
import java.util.List;
import org.hyperledger.fabric.protos.ledger.rwset.kvrwset.KvRwset;

public class FabricTransactionRWSet {
    private List<FabricTransactionRW> reads = new ArrayList<FabricTransactionRW>();
    private List<FabricTransactionRW> writes = new ArrayList<FabricTransactionRW>();

    public void setReads(List<KvRwset.KVRead> readsList) {
        this.reads = new ArrayList<FabricTransactionRW>();
        if (readsList != null) {
            for (int i = 0; i < readsList.size(); ++i) {
                this.reads.add(FabricTransactionRW.fromRead(i, readsList.get(i)));
            }
        }
    }

    public void setWrites(List<KvRwset.KVWrite> writesList) {
        this.writes = new ArrayList<FabricTransactionRW>();
        if (writesList != null && !writesList.isEmpty()) {
            for (int i = 0; i < writesList.size(); ++i) {
                this.writes.add(FabricTransactionRW.fromWrite(i, writesList.get(i)));
            }
        }
    }

    public void addReads(List<KvRwset.KVRead> readsList) {
        if (readsList == null || readsList.isEmpty()) {
            return;
        }
        for (int i = 0; i < readsList.size(); ++i) {
            FabricTransactionRW r = FabricTransactionRW.fromRead(this.reads.size(), readsList.get(i));
            if (r == null) continue;
            this.reads.add(r);
        }
    }

    public void addWrites(List<KvRwset.KVWrite> writesList) {
        if (writesList == null || writesList.isEmpty()) {
            return;
        }
        for (int i = 0; i < writesList.size(); ++i) {
            FabricTransactionRW w = FabricTransactionRW.fromWrite(this.writes.size(), writesList.get(i));
            if (w == null) continue;
            this.writes.add(w);
        }
    }

    public List<FabricTransactionRW> getReads() {
        return this.reads;
    }

    public List<FabricTransactionRW> getWrites() {
        return this.writes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FabricTransactionRWSet)) {
            return false;
        }
        FabricTransactionRWSet other = (FabricTransactionRWSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<FabricTransactionRW> this$reads = this.getReads();
        List<FabricTransactionRW> other$reads = other.getReads();
        if (this$reads == null ? other$reads != null : !((Object)this$reads).equals(other$reads)) {
            return false;
        }
        List<FabricTransactionRW> this$writes = this.getWrites();
        List<FabricTransactionRW> other$writes = other.getWrites();
        return !(this$writes == null ? other$writes != null : !((Object)this$writes).equals(other$writes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FabricTransactionRWSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<FabricTransactionRW> $reads = this.getReads();
        result = result * 59 + ($reads == null ? 43 : ((Object)$reads).hashCode());
        List<FabricTransactionRW> $writes = this.getWrites();
        result = result * 59 + ($writes == null ? 43 : ((Object)$writes).hashCode());
        return result;
    }

    public String toString() {
        return "FabricTransactionRWSet(reads=" + this.getReads() + ", writes=" + this.getWrites() + ")";
    }
}

