/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.bean;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.ecsoya.fabric.json.FabricGson;
import org.hyperledger.fabric.protos.ledger.rwset.kvrwset.KvRwset;

public class FabricTransactionRW {
    private int index;
    private String type = "";
    private String key = "";
    private String value = "";
    private String remarks = "";
    private static final String DELIMITER = new String(Character.toChars(0));

    public static FabricTransactionRW fromRead(int index, KvRwset.KVRead read) {
        if (read == null) {
            return null;
        }
        FabricTransactionRW txRead = new FabricTransactionRW();
        txRead.setIndex(index);
        String key = read.getKey();
        String[] split = key.split(DELIMITER, 0);
        if (split.length >= 2) {
            txRead.setKey(split[split.length - 1]);
            txRead.setType(split[split.length - 2]);
        } else {
            txRead.setKey(key);
        }
        KvRwset.Version version = read.getVersion();
        if (version != null) {
            txRead.setValue("blockNum: " + version.getBlockNum() + ", txNum: " + version.getTxNum());
        }
        return txRead;
    }

    public static FabricTransactionRW fromWrite(int index, KvRwset.KVWrite write) {
        if (write == null) {
            return null;
        }
        FabricTransactionRW txWrite = new FabricTransactionRW();
        txWrite.setIndex(index);
        String compositeKey = write.getKey();
        String[] split = compositeKey.split(DELIMITER, 0);
        if (split.length >= 2) {
            txWrite.setKey(split[split.length - 1]);
            txWrite.setType(split[split.length - 2]);
        } else {
            txWrite.setKey(compositeKey);
        }
        txWrite.setValue(FabricTransactionRW.simplifier(write.getValue().toStringUtf8()));
        txWrite.setRemarks(Boolean.toString(write.getIsDelete()));
        return txWrite;
    }

    private static String simplifier(String value) {
        try {
            JsonObject obj;
            JsonElement valuesObj;
            JsonElement tree = JsonParser.parseString((String)value);
            if (tree.isJsonObject() && (valuesObj = (obj = tree.getAsJsonObject()).get("values")) != null) {
                return FabricGson.stringify(valuesObj);
            }
        }
        catch (Exception e) {
            return value;
        }
        return value;
    }

    public int getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FabricTransactionRW)) {
            return false;
        }
        FabricTransactionRW other = (FabricTransactionRW)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$remarks = this.getRemarks();
        String other$remarks = other.getRemarks();
        return !(this$remarks == null ? other$remarks != null : !this$remarks.equals(other$remarks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FabricTransactionRW;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $remarks = this.getRemarks();
        result = result * 59 + ($remarks == null ? 43 : $remarks.hashCode());
        return result;
    }

    public String toString() {
        return "FabricTransactionRW(index=" + this.getIndex() + ", type=" + this.getType() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", remarks=" + this.getRemarks() + ")";
    }
}

