/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.github.ecsoya.fabric.FabricQueryResponseMetadata;
import io.github.ecsoya.fabric.FabricResponse;
import io.github.ecsoya.fabric.json.FabricGson;
import io.github.ecsoya.fabric.utils.FabricUtil;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;

public class FabricQueryResponse<T>
extends FabricResponse {
    public final T data;
    public FabricQueryResponseMetadata metadata;

    public FabricQueryResponse(int status, String errorMsg, T data) {
        super(status, errorMsg);
        this.data = data;
    }

    public FabricQueryResponseMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(FabricQueryResponseMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public boolean isOk(boolean all) {
        if (all) {
            return this.data != null && super.isOk(all);
        }
        return super.isOk(all);
    }

    public static <T> FabricQueryResponse<T> failure(String errorMsg) {
        return new FabricQueryResponse<Object>(-505, errorMsg, null);
    }

    public static <T> FabricQueryResponse<T> success(T data) {
        return new FabricQueryResponse<T>(1, null, data);
    }

    public static <T> FabricQueryResponse<T> build(T data) {
        if (data == null) {
            return FabricQueryResponse.failure(null);
        }
        return FabricQueryResponse.success(data);
    }

    public static <T> FabricQueryResponse<T> create(ProposalResponse res, Class<T> type) {
        ChaincodeResponse.Status status = res.getStatus();
        if (status != ChaincodeResponse.Status.SUCCESS) {
            return FabricQueryResponse.failure(res.getMessage());
        }
        if (type != null) {
            try {
                int chaincodeStatus = res.getChaincodeActionResponseStatus();
                if (chaincodeStatus != -1) {
                    byte[] payload = res.getChaincodeActionResponsePayload();
                    return FabricQueryResponse.create(payload, type);
                }
                return FabricQueryResponse.failure("Chaincode executed failure.");
            }
            catch (InvalidArgumentException e) {
                return FabricQueryResponse.failure("Chaincode error: " + e.getMessage());
            }
        }
        return FabricQueryResponse.success(null);
    }

    public static <T> FabricQueryResponse<T> create(byte[] payload, Class<T> type) {
        if (payload == null) {
            return FabricQueryResponse.success(null);
        }
        T payloadData = FabricQueryResponse.parsePayload(new String(payload, Charset.forName("utf-8")), type);
        return FabricQueryResponse.success(payloadData);
    }

    private static <T> T parsePayload(String value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (String.class == type) {
            return (T)value;
        }
        if (Number.class.isAssignableFrom(type)) {
            try {
                return (T)NumberFormat.getInstance().parse(value);
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (Boolean.class == type || Boolean.TYPE == type) {
            try {
                return (T)Boolean.valueOf(value);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (!value.equals("")) {
            return FabricUtil.build(value, type);
        }
        return null;
    }

    public static <T> FabricQueryResponse<List<T>> many(ProposalResponse res, Class<T> type) {
        ChaincodeResponse.Status status = res.getStatus();
        if (status != ChaincodeResponse.Status.SUCCESS) {
            return FabricQueryResponse.failure(res.getMessage());
        }
        if (type != null) {
            try {
                int chaincodeStatus = res.getChaincodeActionResponseStatus();
                if (chaincodeStatus != -1) {
                    byte[] payload = res.getChaincodeActionResponsePayload();
                    return FabricQueryResponse.parsePayloadMany(new String(payload, Charset.forName("utf-8")), type);
                }
                return FabricQueryResponse.failure("Chaincode executed failure.");
            }
            catch (InvalidArgumentException e) {
                return FabricQueryResponse.failure("Chaincode error: " + e.getMessage());
            }
        }
        return FabricQueryResponse.success(null);
    }

    public static <T> FabricQueryResponse<List<T>> many(byte[] payloads, Class<T> type) {
        return FabricQueryResponse.parsePayloadMany(new String(payloads, Charset.forName("utf-8")), type);
    }

    private static <T> FabricQueryResponse<List<T>> parsePayloadMany(String json, Class<T> type) {
        try {
            JsonElement element = JsonParser.parseString((String)json);
            JsonArray array = null;
            JsonElement meta = null;
            if (element.isJsonArray()) {
                array = element.getAsJsonArray();
            } else if (element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                JsonElement data = object.get("data");
                if (data.isJsonArray()) {
                    array = data.getAsJsonArray();
                }
                meta = object.get("meta");
            }
            ArrayList<T> results = new ArrayList<T>();
            for (JsonElement child : array) {
                T value = FabricUtil.build(FabricGson.stringify(child), type);
                results.add(value);
            }
            FabricQueryResponse<List<T>> res = FabricQueryResponse.success(results);
            if (meta != null) {
                res.setMetadata(FabricGson.build(meta, FabricQueryResponseMetadata.class));
            }
            return res;
        }
        catch (JsonSyntaxException e) {
            return FabricQueryResponse.failure(e.getMessage());
        }
    }
}

