/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric;

import io.github.ecsoya.fabric.FabricPaginationQuery;
import java.util.ArrayList;
import java.util.List;

public class FabricPagination<T> {
    private List<T> data = new ArrayList<T>();
    private int recordsCount;
    private String bookmark = "";
    private int pageSize = 10;
    private int recordsTotal;
    private int recordsFiltered;
    private int currentPage;

    public void updateTotalRecords() {
        int total = this.currentPage * this.pageSize + this.recordsCount;
        if (this.recordsCount < this.pageSize) {
            this.recordsTotal = total;
            this.recordsFiltered = total;
        } else {
            this.recordsTotal = total + 1;
            this.recordsFiltered = total + 1;
        }
    }

    public static <T> FabricPagination<T> create(FabricPaginationQuery<T> query) {
        FabricPagination<T> pagination = new FabricPagination<T>();
        pagination.setBookmark(query.getBookmark());
        pagination.setPageSize(query.getPageSize());
        pagination.setCurrentPage(query.getCurrentPage());
        return pagination;
    }

    public List<T> getData() {
        return this.data;
    }

    public int getRecordsCount() {
        return this.recordsCount;
    }

    public String getBookmark() {
        return this.bookmark;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getRecordsTotal() {
        return this.recordsTotal;
    }

    public int getRecordsFiltered() {
        return this.recordsFiltered;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public void setRecordsCount(int recordsCount) {
        this.recordsCount = recordsCount;
    }

    public void setBookmark(String bookmark) {
        this.bookmark = bookmark;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setRecordsTotal(int recordsTotal) {
        this.recordsTotal = recordsTotal;
    }

    public void setRecordsFiltered(int recordsFiltered) {
        this.recordsFiltered = recordsFiltered;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FabricPagination)) {
            return false;
        }
        FabricPagination other = (FabricPagination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        if (this.getRecordsCount() != other.getRecordsCount()) {
            return false;
        }
        String this$bookmark = this.getBookmark();
        String other$bookmark = other.getBookmark();
        if (this$bookmark == null ? other$bookmark != null : !this$bookmark.equals(other$bookmark)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getRecordsTotal() != other.getRecordsTotal()) {
            return false;
        }
        if (this.getRecordsFiltered() != other.getRecordsFiltered()) {
            return false;
        }
        return this.getCurrentPage() == other.getCurrentPage();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FabricPagination;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        result = result * 59 + this.getRecordsCount();
        String $bookmark = this.getBookmark();
        result = result * 59 + ($bookmark == null ? 43 : $bookmark.hashCode());
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getRecordsTotal();
        result = result * 59 + this.getRecordsFiltered();
        result = result * 59 + this.getCurrentPage();
        return result;
    }

    public String toString() {
        return "FabricPagination(data=" + this.getData() + ", recordsCount=" + this.getRecordsCount() + ", bookmark=" + this.getBookmark() + ", pageSize=" + this.getPageSize() + ", recordsTotal=" + this.getRecordsTotal() + ", recordsFiltered=" + this.getRecordsFiltered() + ", currentPage=" + this.getCurrentPage() + ")";
    }
}

