/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.server.service;

import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.security.oauth2.common.util.SerializationUtils;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import plus.easydo.starter.oauth.server.model.OauthCode;
import plus.easydo.starter.oauth.server.properties.Oauth2ServerProperties;
import plus.easydo.starter.oauth.server.serializer.FastJsonRedisTokenStoreSerializationStrategy;
import plus.easydo.starter.redis.service.RedisService;

@EnableConfigurationProperties(value={Oauth2ServerProperties.class})
@Configuration
public class CustomizeAuthorizationCodeServices
implements AuthorizationCodeServices {
    private final RandomValueStringGenerator randomValueStringGenerator = new RandomValueStringGenerator(12);
    private final FastJsonRedisTokenStoreSerializationStrategy serializations = new FastJsonRedisTokenStoreSerializationStrategy<OAuth2Authentication>(OAuth2Authentication.class);
    @Resource
    Oauth2ServerProperties oAuth2Properties;
    @Resource
    RedisService redisService;

    public String createAuthorizationCode(OAuth2Authentication oAuth2Authentication) {
        String clientId = oAuth2Authentication.getOAuth2Request().getClientId();
        return this.saveCode(clientId, oAuth2Authentication);
    }

    public OAuth2Authentication consumeAuthorizationCode(String code) {
        String oauthCodePrefix = this.oAuth2Properties.getOauthCodePrefix();
        OauthCode oauthCode = (OauthCode)this.redisService.getCacheObject(oauthCodePrefix + code);
        if (oauthCode != null) {
            this.remove(code, oauthCode.getClientId());
            if (this.oAuth2Properties.isEnableFastJsonSerializer()) {
                return this.serializations.deserialize(oauthCode.getAuthentication(), OAuth2Authentication.class);
            }
            return (OAuth2Authentication)SerializationUtils.deserialize((byte[])oauthCode.getAuthentication());
        }
        throw new InvalidGrantException("\u6388\u6743\u7801\u65e0\u6548: " + code);
    }

    private String saveCode(String clientId, OAuth2Authentication oAuth2Authentication) {
        String oauthCodePrefix;
        String codeClientPrefix = this.oAuth2Properties.getCodeClientPrefix();
        String cacheCode = this.validatorClientIdCode(clientId, codeClientPrefix, oauthCodePrefix = this.oAuth2Properties.getOauthCodePrefix());
        if (cacheCode != null) {
            return cacheCode;
        }
        String code = this.randomValueStringGenerator.generate();
        OauthCode oauthCode = new OauthCode();
        oauthCode.setClientId(clientId);
        oauthCode.setCode(code);
        if (this.oAuth2Properties.isEnableFastJsonSerializer()) {
            oauthCode.setAuthentication(this.serializations.serialize(oAuth2Authentication));
        } else {
            oauthCode.setAuthentication(SerializationUtils.serialize((Object)oAuth2Authentication));
        }
        this.redisService.setCacheObject(codeClientPrefix + clientId, (Object)code);
        this.redisService.expire(codeClientPrefix + clientId, 5L, TimeUnit.MINUTES);
        this.redisService.setCacheObject(oauthCodePrefix + code, (Object)oauthCode);
        this.redisService.expire(oauthCodePrefix + code, 5L, TimeUnit.MINUTES);
        return code;
    }

    private void remove(String code, String clientId) {
        this.redisService.deleteObject(this.oAuth2Properties.getOauthCodePrefix() + code);
        this.redisService.deleteObject(this.oAuth2Properties.getCodeClientPrefix() + clientId);
    }

    private String validatorClientIdCode(String clientId, String codeClientPrefix, String oauthCodePrefix) {
        OauthCode oauthCode;
        String cacheCode = (String)this.redisService.getCacheObject(codeClientPrefix + clientId);
        if (cacheCode != null && (oauthCode = (OauthCode)this.redisService.getCacheObject(oauthCodePrefix + cacheCode)) != null) {
            this.redisService.expire(codeClientPrefix + clientId, 5L, TimeUnit.MINUTES);
            this.redisService.expire(oauthCodePrefix + cacheCode, 5L, TimeUnit.MINUTES);
            return oauthCode.getCode();
        }
        return null;
    }
}

