/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.server.configure;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.client.JdbcClientDetailsService;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore;
import plus.easydo.starter.oauth.core.config.SecurityBeanConfig;
import plus.easydo.starter.oauth.server.exception.CustomizeOauth2WebResponseExceptionTranslator;
import plus.easydo.starter.oauth.server.properties.Oauth2ServerProperties;
import plus.easydo.starter.oauth.server.serializer.FastJsonRedisTokenStoreSerializationStrategy;
import plus.easydo.starter.oauth.server.service.CustomizeAuthorizationCodeServices;
import plus.easydo.starter.oauth.server.service.CustomizeDefaultUserAuthenticationConverter;

@Configuration(value="serverBeanConfig")
@EnableConfigurationProperties(value={Oauth2ServerProperties.class})
public class ServerBeanConfig
implements SecurityBeanConfig<Oauth2ServerProperties> {
    @Resource
    Oauth2ServerProperties oauth2ServerProperties;
    @Resource
    AuthorizationServerTokenServices authorizationServerTokenServices;
    @Resource
    WebResponseExceptionTranslator<OAuth2Exception> webResponseExceptionTranslator;
    @Resource
    private DataSource dataSource;
    @Resource
    private PasswordEncoder passwordEncoder;
    @Resource
    private AuthenticationManager authenticationManager;
    @Resource
    private JdbcClientDetailsService jdbcClientDetailsService;
    @Resource
    private AuthorizationCodeServices authorizationCodeServices;
    @Resource
    private AccessTokenConverter accessTokenConverter;

    public JdbcClientDetailsService getClientDetailsService() {
        return this.jdbcClientDetailsService;
    }

    public AuthorizationServerTokenServices getAuthorizationServerTokenServices() {
        return this.authorizationServerTokenServices;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public Oauth2ServerProperties properties() {
        return this.oauth2ServerProperties;
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public JdbcClientDetailsService jdbcClientDetailsService() {
        return new JdbcClientDetailsService(this.dataSource);
    }

    @Bean
    public AuthorizationServerTokenServices authorizationServerTokenServices(ClientDetailsService clientDetailsService, TokenStore tokenStore) {
        DefaultTokenServices services = new DefaultTokenServices();
        services.setClientDetailsService(clientDetailsService);
        services.setSupportRefreshToken(true);
        services.setTokenStore(tokenStore);
        services.setAccessTokenValiditySeconds(this.oauth2ServerProperties.getAccessTokenValiditySeconds());
        services.setRefreshTokenValiditySeconds(this.oauth2ServerProperties.getRefreshTokenValiditySeconds());
        return services;
    }

    @Bean
    public AuthorizationCodeServices authorizationCodeServices() {
        return new CustomizeAuthorizationCodeServices();
    }

    @Bean
    public AccessTokenConverter accessTokenConverter() {
        DefaultAccessTokenConverter defaultAccessTokenConverter = new DefaultAccessTokenConverter();
        CustomizeDefaultUserAuthenticationConverter defaultUserAuthenticationConverter = new CustomizeDefaultUserAuthenticationConverter(this.oauth2ServerProperties);
        defaultAccessTokenConverter.setUserTokenConverter((UserAuthenticationConverter)defaultUserAuthenticationConverter);
        return defaultAccessTokenConverter;
    }

    @Bean
    public TokenStore tokenStore(LettuceConnectionFactory lettuceConnectionFactory) {
        RedisTokenStore tokenStore = new RedisTokenStore((RedisConnectionFactory)lettuceConnectionFactory);
        tokenStore.setPrefix(this.oauth2ServerProperties.getOathTokenPrefix());
        if (this.oauth2ServerProperties.isEnableFastJsonSerializer()) {
            FastJsonRedisTokenStoreSerializationStrategy<Object> serializer = new FastJsonRedisTokenStoreSerializationStrategy<Object>(Object.class);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
            objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_ARRAY);
            serializer.setObjectMapper(objectMapper);
            lettuceConnectionFactory.afterPropertiesSet();
            tokenStore.setSerializationStrategy(serializer);
        }
        return tokenStore;
    }

    @Bean
    public WebResponseExceptionTranslator<OAuth2Exception> webResponseExceptionTranslator() {
        return new CustomizeOauth2WebResponseExceptionTranslator();
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public AuthorizationCodeServices getAuthorizationCodeServices() {
        return this.authorizationCodeServices;
    }

    public AccessTokenConverter getAccessTokenConverter() {
        return this.accessTokenConverter;
    }

    public WebResponseExceptionTranslator<OAuth2Exception> getWebResponseExceptionTranslator() {
        return this.webResponseExceptionTranslator;
    }
}

