/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.server.configure;

import javax.annotation.Resource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import plus.easydo.starter.oauth.server.configure.ServerBeanConfig;
import plus.easydo.starter.oauth.server.properties.Oauth2ServerProperties;

@Configuration
@EnableAuthorizationServer
@Import(value={ServerBeanConfig.class})
@EnableConfigurationProperties(value={Oauth2ServerProperties.class})
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true, jsr250Enabled=true)
public class AuthorizationServerAutoConfiguration
extends AuthorizationServerConfigurerAdapter {
    @Resource(name="serverBeanConfig")
    private ServerBeanConfig serverBeanConfig;

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        clients.withClientDetails((ClientDetailsService)this.serverBeanConfig.getClientDetailsService());
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) {
        endpoints.exceptionTranslator(this.serverBeanConfig.getWebResponseExceptionTranslator()).accessTokenConverter(this.serverBeanConfig.getAccessTokenConverter()).authenticationManager(this.serverBeanConfig.getAuthenticationManager()).authorizationCodeServices(this.serverBeanConfig.getAuthorizationCodeServices()).tokenServices(this.serverBeanConfig.getAuthorizationServerTokenServices()).allowedTokenEndpointRequestMethods(new HttpMethod[]{HttpMethod.POST, HttpMethod.GET}).pathMapping("/oauth/confirm_access", this.serverBeanConfig.properties().getConfirmAccessPath());
    }

    public void configure(AuthorizationServerSecurityConfigurer security) {
        security.passwordEncoder((PasswordEncoder)new BCryptPasswordEncoder()).tokenKeyAccess("permitAll()").checkTokenAccess("permitAll()").allowFormAuthenticationForClients();
    }
}

