package plus.easydo.starter.oauth.server.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import plus.easydo.starter.oauth.server.properties.Oauth2ServerProperties;

import java.util.Map;

/**
 * 自定义登录、授权页面
 * @author yuzhanfeng
 */
@Controller
public class CustomizeOauthController {

    @Autowired
    Oauth2ServerProperties oAuth2Properties;

    /**
     * 自定义登录页面 向页面传递登录提交url地址
     * @param model model
     * @return 登陆页面
     */
    @GetMapping(value = "${oauth2.customize.login-path:/login}")
    public String loginPage(Model model){
        model.addAttribute(oAuth2Properties.getLoginSubmitUrlKey(),"/auth/authorize");
        return oAuth2Properties.getLoginHtml();
    }

    /**
     * 自定义授权页控制层
     * @param model model
     * @return ModelAndView
     */
    @RequestMapping(value = "${oauth2.customize.confirm-access-path:/custom/confirm_access}")
    public ModelAndView getAccessConfirmation(Map<String, Object> model){
        AuthorizationRequest authorizationRequest = (AuthorizationRequest) model.get("authorizationRequest");
        ModelAndView view = new ModelAndView();
        /*自定义授权页面的html文件名前缀*/
        view.setViewName(oAuth2Properties.getConfirmAccessHtmlPrefix());
        /*客户端id*/
        view.addObject("clientId", authorizationRequest.getClientId());
        /*客户端作用域*/
        view.addObject("scopes",authorizationRequest.getScope());
        return view;
    }




}
