/*
 * Decompiled with CFR 0.152.
 */
package com.eason.network;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rJ\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0003J\u0016\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\r\u0018\u00010\fj\n\u0012\u0004\u0012\u00020\r\u0018\u0001`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/eason/network/ConnectionStateManager;", "", "()V", "connectivityCallback", "Landroid/net/ConnectivityManager$NetworkCallback;", "connectivityManager", "Landroid/net/ConnectivityManager;", "connectivityReceiver", "Landroid/content/BroadcastReceiver;", "isRegistered", "", "listeners", "Ljava/util/HashSet;", "Lcom/eason/network/ConnectionStateManager$OnConnectionStateListener;", "Lkotlin/collections/HashSet;", "stickyIntent", "Landroid/content/Intent;", "register", "", "context", "Landroid/content/Context;", "listener", "release", "startListening", "unregister", "OnConnectionStateListener", "network_release"})
public final class ConnectionStateManager {
    private static HashSet<OnConnectionStateListener> listeners;
    private static ConnectivityManager connectivityManager;
    private static boolean isRegistered;
    private static ConnectivityManager.NetworkCallback connectivityCallback;
    private static BroadcastReceiver connectivityReceiver;
    private static Intent stickyIntent;
    @NotNull
    public static final ConnectionStateManager INSTANCE;

    public final void register(@NotNull Context context, @NotNull OnConnectionStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (connectivityManager == null) {
            Object object = context.getApplicationContext().getSystemService("connectivity");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            connectivityManager = (ConnectivityManager)object;
        }
        if (listeners == null) {
            listeners = new HashSet();
        }
        HashSet<OnConnectionStateListener> hashSet = listeners;
        Intrinsics.checkNotNull(hashSet);
        hashSet.add(listener);
        if (!isRegistered) {
            isRegistered = true;
            this.startListening(context);
        }
    }

    public final void unregister(@NotNull Context context, @NotNull OnConnectionStateListener listener) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            HashSet<OnConnectionStateListener> hashSet = listeners;
            if (hashSet == null) break block2;
            HashSet<OnConnectionStateListener> hashSet2 = hashSet;
            boolean bl = false;
            boolean bl2 = false;
            HashSet<OnConnectionStateListener> it = hashSet2;
            boolean bl3 = false;
            if (it.contains(listener)) {
                it.remove(listener);
            }
            if (it.isEmpty()) {
                INSTANCE.release(context);
                isRegistered = false;
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private final void startListening(Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            connectivityCallback = new ConnectivityManager.NetworkCallback(){

                public void onAvailable(@NotNull Network network) {
                    Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                    super.onAvailable(network);
                    HashSet hashSet = ConnectionStateManager.access$getListeners$p(ConnectionStateManager.INSTANCE);
                    if (hashSet != null) {
                        Iterable $this$forEach$iv = hashSet;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            OnConnectionStateListener it = (OnConnectionStateListener)element$iv;
                            boolean bl = false;
                            it.onAvailable();
                        }
                    }
                }

                public void onLost(@NotNull Network network) {
                    Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                    super.onLost(network);
                    HashSet hashSet = ConnectionStateManager.access$getListeners$p(ConnectionStateManager.INSTANCE);
                    if (hashSet != null) {
                        Iterable $this$forEach$iv = hashSet;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            OnConnectionStateListener it = (OnConnectionStateListener)element$iv;
                            boolean bl = false;
                            it.onLost();
                        }
                    }
                }
            };
            ConnectivityManager connectivityManager = ConnectionStateManager.connectivityManager;
            if (connectivityManager != null) {
                ConnectivityManager.NetworkCallback networkCallback = connectivityCallback;
                Intrinsics.checkNotNull((Object)networkCallback);
                connectivityManager.registerDefaultNetworkCallback(networkCallback);
            }
        } else {
            connectivityReceiver = new BroadcastReceiver(){

                public void onReceive(@Nullable Context context, @Nullable Intent intent) {
                    block4: {
                        block5: {
                            if (ConnectionStateManager.access$getStickyIntent$p(ConnectionStateManager.INSTANCE) != null) {
                                ConnectionStateManager.access$setStickyIntent$p(ConnectionStateManager.INSTANCE, null);
                            }
                            Intent intent2 = intent;
                            if (intent2 == null) break block4;
                            Intent intent3 = intent2;
                            boolean bl = false;
                            boolean bl2 = false;
                            Intent it = intent3;
                            boolean bl3 = false;
                            NetworkInfo networkInfo = (NetworkInfo)it.getParcelableExtra("networkInfo");
                            if (networkInfo == null || !networkInfo.isConnected()) break block5;
                            HashSet hashSet = ConnectionStateManager.access$getListeners$p(ConnectionStateManager.INSTANCE);
                            if (hashSet == null) break block4;
                            Iterable $this$forEach$iv = hashSet;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                OnConnectionStateListener listener = (OnConnectionStateListener)element$iv;
                                boolean bl4 = false;
                                listener.onAvailable();
                            }
                            break block4;
                        }
                        HashSet hashSet = ConnectionStateManager.access$getListeners$p(ConnectionStateManager.INSTANCE);
                        if (hashSet != null) {
                            Iterable $this$forEach$iv = hashSet;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                OnConnectionStateListener listener = (OnConnectionStateListener)element$iv;
                                boolean bl = false;
                                listener.onLost();
                            }
                        }
                    }
                }
            };
            stickyIntent = context.getApplicationContext().registerReceiver(connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private final void release(Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            if (connectivityCallback != null) {
                ConnectivityManager connectivityManager = ConnectionStateManager.connectivityManager;
                if (connectivityManager != null) {
                    ConnectivityManager.NetworkCallback networkCallback = connectivityCallback;
                    Intrinsics.checkNotNull((Object)networkCallback);
                    connectivityManager.unregisterNetworkCallback(networkCallback);
                }
            }
        } else if (connectivityReceiver != null) {
            Context context2 = context.getApplicationContext();
            BroadcastReceiver broadcastReceiver = connectivityReceiver;
            Intrinsics.checkNotNull((Object)broadcastReceiver);
            context2.unregisterReceiver(broadcastReceiver);
        }
        connectivityReceiver = null;
        connectivityCallback = null;
        connectivityManager = null;
    }

    private ConnectionStateManager() {
    }

    static {
        ConnectionStateManager connectionStateManager;
        INSTANCE = connectionStateManager = new ConnectionStateManager();
    }

    public static final /* synthetic */ HashSet access$getListeners$p(ConnectionStateManager $this) {
        ConnectionStateManager connectionStateManager = $this;
        return listeners;
    }

    public static final /* synthetic */ void access$setListeners$p(ConnectionStateManager $this, HashSet hashSet) {
        ConnectionStateManager connectionStateManager = $this;
        listeners = hashSet;
    }

    public static final /* synthetic */ Intent access$getStickyIntent$p(ConnectionStateManager $this) {
        ConnectionStateManager connectionStateManager = $this;
        return stickyIntent;
    }

    public static final /* synthetic */ void access$setStickyIntent$p(ConnectionStateManager $this, Intent intent) {
        ConnectionStateManager connectionStateManager = $this;
        stickyIntent = intent;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lcom/eason/network/ConnectionStateManager$OnConnectionStateListener;", "", "onAvailable", "", "onLost", "network_release"})
    public static interface OnConnectionStateListener {
        public void onAvailable();

        public void onLost();
    }
}

