/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.tableview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import com.didichuxing.doraemonkit.widget.tableview.SelectionOperation;
import com.didichuxing.doraemonkit.widget.tableview.TableConfig;
import com.didichuxing.doraemonkit.widget.tableview.bean.Cell;
import com.didichuxing.doraemonkit.widget.tableview.bean.CellInfo;
import com.didichuxing.doraemonkit.widget.tableview.bean.Column;
import com.didichuxing.doraemonkit.widget.tableview.bean.ColumnInfo;
import com.didichuxing.doraemonkit.widget.tableview.bean.TableData;
import com.didichuxing.doraemonkit.widget.tableview.bean.TableInfo;
import com.didichuxing.doraemonkit.widget.tableview.intface.ISelectFormat;
import com.didichuxing.doraemonkit.widget.tableview.listener.OnColumnClickListener;
import com.didichuxing.doraemonkit.widget.tableview.listener.TableClickObserver;
import com.didichuxing.doraemonkit.widget.tableview.utils.DrawUtils;
import java.util.List;

public class TableProvider<T>
implements TableClickObserver {
    private Rect scaleRect;
    private Rect showRect;
    private TableConfig config;
    private PointF clickPoint;
    private ColumnInfo clickColumnInfo;
    private boolean isClickPoint;
    private OnColumnClickListener onColumnClickListener;
    private SelectionOperation operation;
    private TableData<T> tableData;
    private Rect clipRect;
    private Rect tempRect;
    private PointF tipPoint = new PointF();
    private CellInfo cellInfo = new CellInfo();

    public TableProvider() {
        this.clickPoint = new PointF(-1.0f, -1.0f);
        this.clipRect = new Rect();
        this.tempRect = new Rect();
        this.operation = new SelectionOperation();
        this.config = TableConfig.getInstance();
    }

    public void onDraw(Canvas canvas, Rect scaleRect, Rect showRect, TableData<T> tableData) {
        this.setData(scaleRect, showRect, tableData);
        canvas.save();
        canvas.clipRect(this.showRect);
        this.drawColumnTitle(canvas);
        this.drawCount(canvas);
        this.drawContent(canvas);
        this.operation.draw(canvas, showRect, this.config);
        canvas.restore();
        if (this.isClickPoint && this.clickColumnInfo != null) {
            this.onColumnClickListener.onClick(this.clickColumnInfo);
        }
    }

    private void setData(Rect scaleRect, Rect showRect, TableData<T> tableData) {
        this.isClickPoint = false;
        this.clickColumnInfo = null;
        this.operation.reset();
        this.scaleRect = scaleRect;
        this.showRect = showRect;
        this.tableData = tableData;
    }

    private void drawColumnTitle(Canvas canvas) {
        if (this.config.isShowColumnTitle()) {
            if (this.config.isFixedTitle()) {
                this.drawTitle(canvas);
                canvas.restore();
                canvas.save();
                canvas.clipRect(this.showRect);
            } else {
                this.drawTitle(canvas);
            }
        }
    }

    private void drawCount(Canvas canvas) {
        float left = this.scaleRect.left;
        float bottom = this.config.isFixedCountRow() ? (float)Math.min(this.scaleRect.bottom, this.showRect.bottom) : (float)this.scaleRect.bottom;
        int countHeight = this.tableData.getTableInfo().getCountHeight();
        float top = bottom - (float)countHeight;
        List<ColumnInfo> childColumnInfos = this.tableData.getChildColumnInfos();
        if (DrawUtils.isVerticalMixRect(this.showRect, (int)top, (int)bottom)) {
            int i;
            List<Column> columns = this.tableData.getChildColumns();
            int columnSize = columns.size();
            boolean isPerColumnFixed = false;
            this.clipRect.set(this.showRect);
            int clipCount = 0;
            for (i = 0; i < columnSize; ++i) {
                Column column = columns.get(i);
                float tempLeft = left;
                float width = (float)column.getComputeWidth() * this.config.getZoom();
                if (childColumnInfos.get((int)i).column.isFixed()) {
                    if (left < (float)this.clipRect.left) {
                        left = this.clipRect.left;
                        this.clipRect.left = (int)((float)this.clipRect.left + width);
                        isPerColumnFixed = true;
                    }
                } else if (isPerColumnFixed) {
                    canvas.save();
                    ++clipCount;
                    canvas.clipRect(this.clipRect.left, this.showRect.bottom - countHeight, this.showRect.right, this.showRect.bottom);
                }
                this.tempRect.set((int)left, (int)top, (int)(left + width), (int)bottom);
                left = tempLeft;
                left += width;
            }
            for (i = 0; i < clipCount; ++i) {
                canvas.restore();
            }
        }
    }

    private void drawTitle(Canvas canvas) {
        int dis = this.showRect.top - this.scaleRect.top;
        TableInfo tableInfo = this.tableData.getTableInfo();
        int titleHeight = tableInfo.getTitleHeight() * tableInfo.getMaxLevel();
        int clipHeight = this.config.isFixedTitle() ? titleHeight : Math.max(0, titleHeight - dis);
        this.clipRect.set(this.showRect);
        List<ColumnInfo> columnInfoList = this.tableData.getColumnInfos();
        float zoom = this.config.getZoom();
        boolean isPerColumnFixed = false;
        int clipCount = 0;
        ColumnInfo parentColumnInfo = null;
        for (ColumnInfo info : columnInfoList) {
            int left = (int)((float)info.left * zoom + (float)this.scaleRect.left);
            if (info.top == 0 && info.column.isFixed()) {
                if (left < this.clipRect.left) {
                    parentColumnInfo = info;
                    left = this.clipRect.left;
                    this.fillColumnTitle(canvas, info, left);
                    this.clipRect.left = (int)((float)this.clipRect.left + (float)info.width * zoom);
                    isPerColumnFixed = true;
                    continue;
                }
            } else if (isPerColumnFixed && info.top != 0) {
                left = (int)((float)this.clipRect.left - (float)info.width * zoom);
                left += info.left - parentColumnInfo.left;
            } else if (isPerColumnFixed) {
                canvas.save();
                canvas.clipRect(this.clipRect.left, this.showRect.top, this.showRect.right, this.showRect.top + clipHeight);
                isPerColumnFixed = false;
                ++clipCount;
            }
            this.fillColumnTitle(canvas, info, left);
        }
        for (int i = 0; i < clipCount; ++i) {
            canvas.restore();
        }
        if (this.config.isFixedTitle()) {
            this.scaleRect.top += titleHeight;
            this.showRect.top += titleHeight;
        } else {
            this.showRect.top += clipHeight;
            this.scaleRect.top += titleHeight;
        }
    }

    private void fillColumnTitle(Canvas canvas, ColumnInfo info, int left) {
        int bottom;
        int right;
        int top = (int)((float)info.top * this.config.getZoom()) + (this.config.isFixedTitle() ? this.showRect.top : this.scaleRect.top);
        if (DrawUtils.isMixRect(this.showRect, left, top, right = (int)((float)left + (float)info.width * this.config.getZoom()), bottom = (int)((float)top + (float)info.height * this.config.getZoom()))) {
            if (!this.isClickPoint && this.onColumnClickListener != null && DrawUtils.isClick(left, top, right, bottom, this.clickPoint)) {
                this.isClickPoint = true;
                this.clickColumnInfo = info;
                this.clickPoint.set(-1.0f, -1.0f);
            }
            Paint paint = this.config.getPaint();
            this.tempRect.set(left, top, right, bottom);
            this.config.columnTitleGridStyle.fillPaint(paint);
            canvas.drawRect(this.tempRect, paint);
            this.tableData.getTitleDrawFormat().draw(canvas, info.column, this.tempRect, this.config);
        }
    }

    private void drawContent(Canvas canvas) {
        int i;
        float left = this.scaleRect.left;
        List<Column> columns = this.tableData.getChildColumns();
        this.clipRect.set(this.showRect);
        TableInfo info = this.tableData.getTableInfo();
        int columnSize = columns.size();
        if (this.config.isFixedCountRow()) {
            canvas.save();
            canvas.clipRect(this.showRect.left, this.showRect.top, this.showRect.right, this.showRect.bottom - info.getCountHeight());
        }
        List<ColumnInfo> childColumnInfo = this.tableData.getChildColumnInfos();
        boolean isPerFixed = false;
        int clipCount = 0;
        for (i = 0; i < columnSize; ++i) {
            float top = this.scaleRect.top;
            Column column = columns.get(i);
            float width = (float)column.getComputeWidth() * this.config.getZoom();
            float tempLeft = left;
            Column topColumn = childColumnInfo.get((int)i).column;
            if (topColumn.isFixed()) {
                isPerFixed = false;
                if (tempLeft < (float)this.clipRect.left) {
                    left = this.clipRect.left;
                    this.clipRect.left = (int)((float)this.clipRect.left + width);
                    isPerFixed = true;
                }
            } else if (isPerFixed) {
                canvas.save();
                canvas.clipRect(this.clipRect);
                isPerFixed = false;
                ++clipCount;
            }
            float right = left + width;
            if (!(left < (float)this.showRect.right)) break;
            int size = column.getDatas().size();
            int realPosition = 0;
            for (int j = 0; j < size; ++j) {
                String value = column.format(j);
                int totalLineHeight = 0;
                for (int k = realPosition; k < realPosition + 1; ++k) {
                    totalLineHeight += info.getLineHeightArray()[k];
                }
                ++realPosition;
                float bottom = top + (float)totalLineHeight * this.config.getZoom();
                this.tempRect.set((int)left, (int)top, (int)right, (int)bottom);
                Rect correctCellRect = this.correctCellRect(j, i, this.tempRect, this.config.getZoom());
                if (correctCellRect != null) {
                    if (correctCellRect.top >= this.showRect.bottom) break;
                    if (correctCellRect.right > this.showRect.left && correctCellRect.bottom > this.showRect.top) {
                        Object data = column.getDatas().get(j);
                        if (DrawUtils.isClick(correctCellRect, this.clickPoint)) {
                            this.operation.setSelectionRect(i, j, correctCellRect);
                            this.tipPoint.x = (left + right) / 2.0f;
                            this.tipPoint.y = (top + bottom) / 2.0f;
                            this.clickColumn(column, j, value, data);
                            this.isClickPoint = true;
                            this.clickPoint.set(-2.1474836E9f, -2.1474836E9f);
                        }
                        this.operation.checkSelectedPoint(i, j, correctCellRect);
                        this.cellInfo.set(column, data, value, i, j);
                        this.drawContentCell(canvas, this.cellInfo, correctCellRect);
                    }
                }
                top = bottom;
            }
            left = tempLeft + width;
        }
        for (i = 0; i < clipCount; ++i) {
            canvas.restore();
        }
        if (this.config.isFixedCountRow()) {
            canvas.restore();
        }
    }

    protected void drawContentCell(Canvas c, CellInfo<T> cellInfo, Rect rect) {
        this.config.contentGridStyle.fillPaint(this.config.getPaint());
        c.drawRect(rect, this.config.getPaint());
        rect.left += this.config.getTextLeftOffset();
        cellInfo.column.getDrawFormat().draw(c, rect, cellInfo);
    }

    private void clickColumn(Column column, int position, String value, Object data) {
        if (!this.isClickPoint && column.getOnColumnItemClickListener() != null) {
            column.getOnColumnItemClickListener().onClick(column, value, data, position);
        }
    }

    @Override
    public void onClick(float x, float y) {
        this.clickPoint.x = x;
        this.clickPoint.y = y;
    }

    public OnColumnClickListener getOnColumnClickListener() {
        return this.onColumnClickListener;
    }

    public void setOnColumnClickListener(OnColumnClickListener onColumnClickListener) {
        this.onColumnClickListener = onColumnClickListener;
    }

    public void setSelectFormat(ISelectFormat selectFormat) {
        this.operation.setSelectFormat(selectFormat);
    }

    public int[] getPointLocation(double row, double col) {
        List<Column> childColumns = this.tableData.getChildColumns();
        int[] lineHeights = this.tableData.getTableInfo().getLineHeightArray();
        int x = 0;
        int y = 0;
        int columnSize = childColumns.size();
        int i = 0;
        while (true) {
            double d2 = i;
            double d3 = (double)columnSize > col + 1.0 ? col + 1.0 : (double)(columnSize - 1);
            if (!(d2 <= d3)) break;
            int w = childColumns.get(i).getComputeWidth();
            x = i == (int)col + 1 ? (int)((double)x + (double)w * (col - (double)((int)col))) : (x += w);
            ++i;
        }
        i = 0;
        while (true) {
            double d4 = i;
            double d5 = (double)lineHeights.length > row + 1.0 ? row + 1.0 : (double)(lineHeights.length - 1);
            if (!(d4 <= d5)) break;
            int h = lineHeights[i];
            y = i == (int)row + 1 ? (int)((double)y + (double)h * (row - (double)((int)row))) : (y += h);
            ++i;
        }
        x = (int)((float)x * this.config.getZoom());
        y = (int)((float)y * this.config.getZoom());
        return new int[]{x += this.scaleRect.left, y += this.scaleRect.top};
    }

    public int[] getPointSize(int row, int col) {
        List<Column> childColumns = this.tableData.getChildColumns();
        int[] lineHeights = this.tableData.getTableInfo().getLineHeightArray();
        col = col < childColumns.size() ? col : childColumns.size() - 1;
        row = row < lineHeights.length ? row : lineHeights.length;
        col = col < 0 ? 0 : col;
        row = row < 0 ? 0 : row;
        return new int[]{(int)((float)childColumns.get(col).getComputeWidth() * this.config.getZoom()), (int)((float)lineHeights[row] * this.config.getZoom())};
    }

    private Rect correctCellRect(int row, int col, Rect rect, float zoom) {
        Cell point;
        Cell[][] rangePoints = this.tableData.getTableInfo().getRangeCells();
        if (rangePoints != null && rangePoints.length > row && (point = rangePoints[row][col]) != null) {
            if (point.col != -1 && point.row != -1) {
                int i;
                List<Column> childColumns = this.tableData.getChildColumns();
                int[] lineHeights = this.tableData.getTableInfo().getLineHeightArray();
                int width = 0;
                int height = 0;
                for (i = col; i < Math.min(childColumns.size(), col + point.col); ++i) {
                    width += childColumns.get(i).getComputeWidth();
                }
                for (i = row; i < Math.min(lineHeights.length, row + point.row); ++i) {
                    height += lineHeights[i];
                }
                rect.right = (int)((float)rect.left + (float)width * zoom);
                rect.bottom = (int)((float)rect.top + (float)height * zoom);
                return rect;
            }
            return null;
        }
        return rect;
    }

    public SelectionOperation getOperation() {
        return this.operation;
    }
}

