/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.tableview;

import android.graphics.Paint;
import android.graphics.Rect;
import com.didichuxing.doraemonkit.widget.tableview.TableConfig;
import com.didichuxing.doraemonkit.widget.tableview.bean.Cell;
import com.didichuxing.doraemonkit.widget.tableview.bean.Column;
import com.didichuxing.doraemonkit.widget.tableview.bean.ColumnInfo;
import com.didichuxing.doraemonkit.widget.tableview.bean.TableData;
import com.didichuxing.doraemonkit.widget.tableview.bean.TableInfo;
import com.didichuxing.doraemonkit.widget.tableview.intface.ITableTitle;
import java.util.List;

public class TableMeasurer<T> {
    private boolean isReMeasure;

    public TableInfo measure(TableData<T> tableData, int width, int height) {
        this.isReMeasure = true;
        TableInfo tableInfo = tableData.getTableInfo();
        width = Math.max(this.getTableWidth(tableData), width);
        height = Math.max(this.getTableHeight(tableData), height);
        tableInfo.setTableRect(new Rect(0, 0, width, height));
        this.measureColumnSize(tableData);
        return tableInfo;
    }

    public void measureTableTitle(TableData<T> tableData, ITableTitle tableTitle, Rect showRect) {
        TableInfo tableInfo = tableData.getTableInfo();
        Rect tableRect = tableInfo.getTableRect();
        if (this.isReMeasure) {
            this.isReMeasure = false;
            int size = tableTitle.getSize();
            tableInfo.setTitleDirection(tableTitle.getDirection());
            tableInfo.setTableTitleSize(size);
            if (tableTitle.getDirection() == 1 || tableTitle.getDirection() == 3) {
                int height = size;
                tableRect.bottom += height;
                this.reSetShowRect(showRect, tableRect);
            } else {
                int width = size;
                tableRect.right += width;
                this.reSetShowRect(showRect, tableRect);
            }
        } else {
            this.reSetShowRect(showRect, tableRect);
        }
    }

    public void reSetShowRect(Rect showRect, Rect tableRect) {
        if (showRect.bottom > tableRect.bottom) {
            showRect.bottom = tableRect.bottom;
        }
        if (showRect.right > tableRect.right) {
            showRect.right = tableRect.right;
        }
    }

    public void addTableHeight(TableData<T> tableData) {
        TableInfo tableInfo = tableData.getTableInfo();
        int width = this.getTableWidth(tableData);
        int height = this.getTableHeight(tableData);
        tableInfo.setTableRect(new Rect(0, 0, width, height));
    }

    private int getTableHeight(TableData<T> tableData) {
        TableConfig config = TableConfig.getInstance();
        int topHeight = 0;
        int titleHeight = config.isShowColumnTitle() ? tableData.getTitleDrawFormat().measureHeight(config) + 2 * config.getColumnTitleVerticalPadding() : 0;
        TableInfo tableInfo = tableData.getTableInfo();
        tableInfo.setTitleHeight(titleHeight);
        tableInfo.setTopHeight(topHeight);
        int totalContentHeight = 0;
        for (int height : tableInfo.getLineHeightArray()) {
            totalContentHeight += height;
        }
        int totalTitleHeight = titleHeight * tableInfo.getMaxLevel();
        int totalHeight = topHeight + totalTitleHeight + totalContentHeight;
        return totalHeight;
    }

    private int getTableWidth(TableData<T> tableData) {
        int totalWidth = 0;
        TableConfig config = TableConfig.getInstance();
        Paint paint = config.getPaint();
        config.YSequenceStyle.fillPaint(paint);
        int totalSize = tableData.getLineSize();
        if (config.isShowYSequence()) {
            int yAxisWidth = (int)paint.measureText(tableData.getYSequenceFormat().format(totalSize) + 2 * config.getSequenceHorizontalPadding());
            tableData.getTableInfo().setyAxisWidth(yAxisWidth);
            totalWidth += yAxisWidth;
        }
        int columnPos = 0;
        int contentWidth = 0;
        int[] lineHeightArray = tableData.getTableInfo().getLineHeightArray();
        for (Column column : tableData.getChildColumns()) {
            float columnNameWidth = tableData.getTitleDrawFormat().measureWidth(column, config) + config.getColumnTitleHorizontalPadding() * 2;
            int columnWidth = 0;
            int size = column.getDatas().size();
            int currentPosition = 0;
            Cell[][] rangeCells = tableData.getTableInfo().getRangeCells();
            for (int position = 0; position < size; ++position) {
                Cell cell;
                int width = column.getDrawFormat().measureWidth(column, position);
                this.measureRowHeight(lineHeightArray, column, currentPosition, position);
                ++currentPosition;
                if (rangeCells != null && (cell = rangeCells[position][columnPos]) != null) {
                    if (cell.row != -1 && cell.col != -1) {
                        cell.width = width;
                        width /= cell.col;
                    } else if (cell.realCell != null) {
                        width = cell.realCell.width / cell.realCell.col;
                    }
                }
                if (columnWidth >= width) continue;
                columnWidth = width;
            }
            int width = (int)Math.max(columnNameWidth, (float)(columnWidth + 2 * config.getHorizontalPadding()));
            width = Math.max(column.getMinWidth(), width);
            column.setComputeWidth(width);
            contentWidth += width;
            ++columnPos;
        }
        int minWidth = config.getMinTableWidth();
        if (minWidth == -1 || minWidth - totalWidth < contentWidth) {
            totalWidth += contentWidth;
        } else {
            float widthScale = (float)(minWidth -= totalWidth) / (float)contentWidth;
            for (Column column : tableData.getChildColumns()) {
                column.setComputeWidth((int)(widthScale * (float)column.getComputeWidth()));
            }
            totalWidth += minWidth;
        }
        return totalWidth;
    }

    private void measureRowHeight(int[] lineHeightArray, Column column, int currentPosition, int position) {
        TableConfig config = TableConfig.getInstance();
        int height = 0;
        if (height == 0) {
            height = column.getDrawFormat().measureHeight(column, position) + 2 * config.getVerticalPadding();
        }
        if ((height = Math.max(column.getMinHeight(), height)) > lineHeightArray[currentPosition]) {
            lineHeightArray[currentPosition] = height;
        }
    }

    private void measureColumnSize(TableData<T> tableData) {
        List<Column> columnList = tableData.getColumns();
        int left = 0;
        int maxLevel = tableData.getTableInfo().getMaxLevel();
        tableData.getColumnInfos().clear();
        tableData.getChildColumnInfos().clear();
        for (int i = 0; i < columnList.size(); ++i) {
            int top = 0;
            Column column = columnList.get(i);
            ColumnInfo columnInfo = this.getColumnInfo(tableData, column, null, left, top, maxLevel);
            left += columnInfo.width;
        }
    }

    public ColumnInfo getColumnInfo(TableData<T> tableData, Column column, ColumnInfo parent, int left, int top, int overLevel) {
        TableInfo tableInfo = tableData.getTableInfo();
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.value = column.getColumnName();
        columnInfo.column = column;
        columnInfo.width = column.getComputeWidth();
        columnInfo.top = top;
        columnInfo.height = tableInfo.getTitleHeight() * overLevel;
        columnInfo.left = left;
        tableData.getChildColumnInfos().add(columnInfo);
        tableData.getColumnInfos().add(columnInfo);
        return columnInfo;
    }
}

