/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.easyrefresh.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.widget.easyrefresh.IRefreshHeader;
import com.didichuxing.doraemonkit.widget.easyrefresh.State;

public class SimpleRefreshHeaderView
extends FrameLayout
implements IRefreshHeader {
    private Animation rotate_up;
    private Animation rotate_down;
    private Animation rotate_infinite;
    private TextView textView;
    private View arrowIcon;
    private View successIcon;
    private View loadingIcon;

    public SimpleRefreshHeaderView(Context context) {
        this(context, null);
    }

    public SimpleRefreshHeaderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.rotate_up = AnimationUtils.loadAnimation((Context)context, (int)R.anim.dk_easy_refresh_rotate_up);
        this.rotate_down = AnimationUtils.loadAnimation((Context)context, (int)R.anim.dk_easy_refresh_rotate_down);
        this.rotate_infinite = AnimationUtils.loadAnimation((Context)context, (int)R.anim.dk_easy_refresh_rotate_infinite);
        SimpleRefreshHeaderView.inflate((Context)context, (int)R.layout.dk_refresh_default_refresh_header, (ViewGroup)this);
        this.textView = (TextView)this.findViewById(R.id.text);
        this.arrowIcon = this.findViewById(R.id.arrowIcon);
        this.successIcon = this.findViewById(R.id.successIcon);
        this.loadingIcon = this.findViewById(R.id.loadingIcon);
    }

    @Override
    public void reset() {
        this.textView.setText(this.getResources().getText(R.string.dk_header_reset));
        this.successIcon.setVisibility(4);
        this.arrowIcon.setVisibility(0);
        this.arrowIcon.clearAnimation();
        this.loadingIcon.setVisibility(4);
        this.loadingIcon.clearAnimation();
    }

    @Override
    public void pull() {
    }

    @Override
    public void refreshing() {
        this.arrowIcon.setVisibility(4);
        this.loadingIcon.setVisibility(0);
        this.textView.setText(this.getResources().getText(R.string.dk_header_refreshing));
        this.arrowIcon.clearAnimation();
        this.loadingIcon.startAnimation(this.rotate_infinite);
    }

    @Override
    public void onPositionChange(float currentPos, float lastPos, float refreshPos, boolean isTouch, State state) {
        if (currentPos < refreshPos && lastPos >= refreshPos) {
            Log.i((String)"", (String)">>>>up");
            if (isTouch && state == State.PULL) {
                this.textView.setText(this.getResources().getText(R.string.dk_header_pull));
                this.arrowIcon.clearAnimation();
                this.arrowIcon.startAnimation(this.rotate_down);
            }
        } else if (currentPos > refreshPos && lastPos <= refreshPos) {
            Log.i((String)"", (String)">>>>down");
            if (isTouch && state == State.PULL) {
                this.textView.setText(this.getResources().getText(R.string.dk_header_pull_over));
                this.arrowIcon.clearAnimation();
                this.arrowIcon.startAnimation(this.rotate_up);
            }
        }
    }

    @Override
    public void complete() {
        this.loadingIcon.setVisibility(4);
        this.loadingIcon.clearAnimation();
        this.successIcon.setVisibility(0);
        this.textView.setText(this.getResources().getText(R.string.dk_header_completed));
    }
}

