/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.Camera;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Formatter;
import android.util.Log;
import com.didichuxing.doraemonkit.util.DeviceUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;

public class DokitDeviceUtils {
    private static final String TAG = "DeviceUtils";
    private static final String PREF_DEVICE = "com.kuaidi.daijia.driver.device_pref";
    private static final String KEY_UUID = "key_uuid";
    private static final String BRAND_HUAWEI = "huawei";
    private static final String BRAND_HONOR = "honor";
    private static final String BRAND_SAMSUNG = "samsung";
    private static final String BRAND_XIAOMI = "xiaomi";
    private static final String BRAND_HONGMI = "hongmi";
    private static String IMEI = "";
    private static String IMSI = "";
    private static String PHONE_NUMBER = null;
    private static Boolean ROOTED = null;

    public static int getCoreNum() {
        try {
            File dir = new File("/sys/devices/system/cpu/");
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File pathname) {
                    return Pattern.matches("cpu[0-9]", pathname.getName());
                }
            }
            File[] files = dir.listFiles(new CpuFilter());
            return files.length;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"getCoreNum", (Throwable)e);
            return 1;
        }
    }

    public static long getTotalMemory(Context context) {
        String str1 = "/proc/meminfo";
        long initial_memory = 0L;
        try {
            FileReader localFileReader = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(localFileReader, 8192);
            String str2 = localBufferedReader.readLine();
            if (!TextUtils.isEmpty((CharSequence)str2)) {
                String[] arrayOfString = str2.split("\\s+");
                initial_memory = Integer.valueOf(arrayOfString[1]) / 1024;
            }
            localBufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return initial_memory;
    }

    public static long getAvailMemory(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        return mi.availMem / 1024L / 1024L;
    }

    public static String getVersionName(Context context) {
        PackageInfo pi = DokitDeviceUtils.getPackageInfo(context);
        if (pi != null) {
            return pi.versionName;
        }
        return "";
    }

    public static int getVersionCode(Context context) {
        PackageInfo pi = DokitDeviceUtils.getPackageInfo(context);
        if (pi != null) {
            return pi.versionCode;
        }
        return 0;
    }

    public static PackageInfo getPackageInfo(Context context) {
        PackageInfo pi = null;
        try {
            PackageManager pm = context.getPackageManager();
            pi = pm.getPackageInfo(context.getPackageName(), 16384);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pi;
    }

    public static PackageInfo getPackageInfoForPermission(Context context) {
        PackageInfo pi = null;
        try {
            PackageManager pm = context.getPackageManager();
            pi = pm.getPackageInfo(context.getPackageName(), 4096);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pi;
    }

    public static String getWifiSSID(Context context) {
        WifiManager mWifi = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (mWifi.isWifiEnabled()) {
            WifiInfo wifiInfo = mWifi.getConnectionInfo();
            return wifiInfo.getSSID();
        }
        return "";
    }

    public static String getWifiBSSID(Context context) {
        WifiManager mWifi = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (mWifi.isWifiEnabled()) {
            WifiInfo wifiInfo = mWifi.getConnectionInfo();
            return wifiInfo.getBSSID();
        }
        return "";
    }

    public static boolean checkPermission(Context context, String permission2, boolean defalutValue) {
        boolean permit = false;
        try {
            permit = 0 == context.checkCallingOrSelfPermission(permission2);
        }
        catch (Exception e) {
            permit = defalutValue;
        }
        return permit;
    }

    public static boolean isWifiEnabled(Context context) {
        WifiManager wm = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        return wm != null && (wm.getWifiState() == 3 || wm.getWifiState() == 2);
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.isConnected() && activeNetInfo.getType() == 1;
    }

    public static boolean hasJellyBeanMr2() {
        return Build.VERSION.SDK_INT >= 18;
    }

    public static boolean hasJellyBeanMr1() {
        return Build.VERSION.SDK_INT >= 17;
    }

    public static boolean isProduceByBrand(String brand) {
        boolean result2 = false;
        if (Build.MANUFACTURER != null && Build.MANUFACTURER.toLowerCase().contains(brand)) {
            result2 = true;
        }
        if (!result2 && Build.BRAND != null && Build.BRAND.toLowerCase().contains(brand)) {
            result2 = true;
        }
        return result2;
    }

    public static boolean isProduceByXiaomi() {
        return DokitDeviceUtils.isProductInBrands(BRAND_XIAOMI, BRAND_HONGMI);
    }

    public static boolean isProduceByHuaWei() {
        return DokitDeviceUtils.isProductInBrands(BRAND_HUAWEI, BRAND_HONOR);
    }

    public static boolean isProduceBySamsung() {
        return DokitDeviceUtils.isProduceByBrand(BRAND_SAMSUNG);
    }

    public static boolean isProductInBrands(String ... brands) {
        for (String brand : brands) {
            if (!DokitDeviceUtils.isProduceByBrand(brand)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSimReady(Context context) {
        try {
            TelephonyManager mgr = (TelephonyManager)context.getSystemService("phone");
            Log.d((String)TAG, (String)("[isSimReady]" + mgr.getSimState()));
            return 5 == mgr.getSimState() || 4 == mgr.getSimState();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("[isSimReady]" + e));
            return false;
        }
    }

    public static boolean isRoot(Context context) {
        if (ROOTED != null) {
            return ROOTED;
        }
        try {
            ROOTED = DeviceUtils.isDeviceRooted();
            if (ROOTED.booleanValue()) {
                Log.w((String)TAG, (String)"Device rooted.");
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Check root failed.", (Throwable)e);
            ROOTED = false;
        }
        return ROOTED;
    }

    public static boolean hasFrontCamera() {
        int cameraCount = Camera.getNumberOfCameras();
        Camera.CameraInfo info = new Camera.CameraInfo();
        for (int i = 0; i < cameraCount; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (1 != info.facing) continue;
            return true;
        }
        return false;
    }

    public static long getExternalAvailableSpaceInBytes() {
        long availableSpace = -1L;
        try {
            StatFs stat = new StatFs(Environment.getExternalStorageDirectory().getPath());
            availableSpace = (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return availableSpace;
    }

    private static String getSDTotalSize(Context context) {
        File path = Environment.getExternalStorageDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long totalBlocks = stat.getBlockCount();
        return Formatter.formatFileSize((Context)context, (long)(blockSize * totalBlocks));
    }

    private static String getSDAvailableSize(Context context) {
        File path = Environment.getExternalStorageDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return Formatter.formatFileSize((Context)context, (long)(blockSize * availableBlocks));
    }

    private static String getRomTotalSize(Context context) {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long totalBlocks = stat.getBlockCount();
        return Formatter.formatFileSize((Context)context, (long)(blockSize * totalBlocks));
    }

    private static String getRomAvailableSize(Context context) {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return Formatter.formatFileSize((Context)context, (long)(blockSize * availableBlocks));
    }

    public static String getSDCardSpace(Context context) {
        try {
            String free = DokitDeviceUtils.getSDAvailableSize(context);
            String total = DokitDeviceUtils.getSDTotalSize(context);
            return free + "/" + total;
        }
        catch (Exception e) {
            return "-/-";
        }
    }

    public static String getRomSpace(Context context) {
        try {
            String free = DokitDeviceUtils.getRomAvailableSize(context);
            String total = DokitDeviceUtils.getRomTotalSize(context);
            return free + "/" + total;
        }
        catch (Exception e) {
            return "-/-";
        }
    }
}

