/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.content.Context;
import android.os.Environment;
import android.text.format.Formatter;
import com.didichuxing.doraemonkit.util.DoKitFileUtil;
import com.didichuxing.doraemonkit.util.PathUtils;
import java.io.File;

public class DataCleanUtil {
    private DataCleanUtil() {
    }

    public static void cleanInternalCache(Context context) {
        DoKitFileUtil.deleteDirectory(context.getCacheDir());
    }

    public static void cleanDatabases(Context context) {
        DoKitFileUtil.deleteDirectory(new File(context.getFilesDir().getParent() + "/databases"));
    }

    public static void cleanSharedPreference(Context context) {
        DoKitFileUtil.deleteDirectory(new File(context.getFilesDir().getParent() + "/shared_prefs"));
    }

    public static void cleanFiles(Context context) {
        DoKitFileUtil.deleteDirectory(context.getFilesDir());
    }

    public static void cleanExternalCache(Context context) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            DoKitFileUtil.deleteDirectory(context.getExternalCacheDir());
        }
    }

    public static void cleanCustomCache(String filePath) {
        DoKitFileUtil.deleteDirectory(new File(filePath));
    }

    public static void cleanApplicationData(Context context, String ... filepath) {
        DataCleanUtil.cleanInternalCache(context);
        DataCleanUtil.cleanExternalCache(context);
        DataCleanUtil.cleanDatabases(context);
        DataCleanUtil.cleanSharedPreference(context);
        DataCleanUtil.cleanFiles(context);
        if (filepath == null) {
            return;
        }
        for (String filePath : filepath) {
            DataCleanUtil.cleanCustomCache(filePath);
        }
    }

    public static long getApplicationDataSize(Context context) {
        return DoKitFileUtil.getDirectorySize(new File(PathUtils.getInternalAppDataPath()));
    }

    public static String getApplicationDataSizeStr(Context context) {
        return Formatter.formatFileSize((Context)context, (long)DataCleanUtil.getApplicationDataSize(context));
    }
}

