/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.picasso;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.Uri;
import com.didichuxing.doraemonkit.picasso.DokitPicasso;
import com.didichuxing.doraemonkit.picasso.Request;
import com.didichuxing.doraemonkit.picasso.RequestHandler;
import java.io.IOException;
import java.io.InputStream;

class AssetRequestHandler
extends RequestHandler {
    protected static final String ANDROID_ASSET = "android_asset";
    private static final int ASSET_PREFIX_LENGTH = "file:///android_asset/".length();
    private final AssetManager assetManager;

    public AssetRequestHandler(Context context) {
        this.assetManager = context.getAssets();
    }

    @Override
    public boolean canHandleRequest(Request data) {
        Uri uri = data.uri;
        return "file".equals(uri.getScheme()) && !uri.getPathSegments().isEmpty() && ANDROID_ASSET.equals(uri.getPathSegments().get(0));
    }

    @Override
    public RequestHandler.Result load(Request request2, int networkPolicy) throws IOException {
        InputStream is = this.assetManager.open(AssetRequestHandler.getFilePath(request2));
        return new RequestHandler.Result(is, DokitPicasso.LoadedFrom.DISK);
    }

    static String getFilePath(Request request2) {
        return request2.uri.toString().substring(ASSET_PREFIX_LENGTH);
    }
}

