/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.webdoor;

import android.content.Context;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.kit.webdoor.WebDoorDefaultFragment;
import com.didichuxing.doraemonkit.kit.webview.WebViewManager;
import com.didichuxing.doraemonkit.util.DoKitCacheUtils;
import java.util.ArrayList;

public class WebDoorManager {
    private static final String TAG = "WebDoorManager";
    private WebDoorCallback mWebDoorCallback = new DefaultWebDoorCallback();
    private ArrayList<String> mHistory;

    public WebDoorCallback getWebDoorCallback() {
        return this.mWebDoorCallback;
    }

    public void setWebDoorCallback(WebDoorCallback webDoorCallback) {
        this.mWebDoorCallback = webDoorCallback;
    }

    public void removeWebDoorCallback() {
        this.mWebDoorCallback = null;
    }

    public void saveHistory(String text) {
        if (this.mHistory == null) {
            this.mHistory = (ArrayList)DoKitCacheUtils.readObject("web_door_history");
        }
        if (this.mHistory == null) {
            this.mHistory = new ArrayList();
        }
        if (this.mHistory.contains(text)) {
            return;
        }
        if (this.mHistory.size() == 5) {
            this.mHistory.remove(0);
        }
        this.mHistory.add(text);
        DoKitCacheUtils.saveObject("web_door_history", this.mHistory);
    }

    public ArrayList<String> getHistory() {
        if (this.mHistory == null) {
            this.mHistory = (ArrayList)DoKitCacheUtils.readObject("web_door_history");
        }
        if (this.mHistory == null) {
            this.mHistory = new ArrayList();
        }
        return this.mHistory;
    }

    public void clearHistory() {
        this.mHistory.clear();
        DoKitCacheUtils.saveObject("web_door_history", this.mHistory);
    }

    public static WebDoorManager getInstance() {
        return Holder.INSTANCE;
    }

    private class DefaultWebDoorCallback
    implements WebDoorCallback {
        private DefaultWebDoorCallback() {
        }

        @Override
        public void overrideUrlLoading(Context context, String url) {
            WebViewManager.INSTANCE.setUrl(url);
            DoKit.launchFullScreen(WebDoorDefaultFragment.class, context);
        }
    }

    public static interface WebDoorCallback {
        public void overrideUrlLoading(Context var1, String var2);
    }

    private static class Holder {
        private static WebDoorManager INSTANCE = new WebDoorManager();

        private Holder() {
        }
    }
}

