/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.weaknetwork;

import android.os.SystemClock;
import com.didichuxing.doraemonkit.kit.weaknetwork.SpeedLimitRequestBody;
import com.didichuxing.doraemonkit.kit.weaknetwork.SpeedLimitResponseBody;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class WeakNetworkManager {
    public static final int TYPE_OFF_NETWORK = 0;
    public static final int TYPE_TIMEOUT = 1;
    public static final int TYPE_SPEED_LIMIT = 2;
    public static final int DEFAULT_TIMEOUT_MILLIS = 2000;
    public static final int DEFAULT_REQUEST_SPEED = 1;
    public static final int DEFAULT_RESPONSE_SPEED = 1;
    private int mType = 0;
    private long mTimeOutMillis = 2000L;
    private long mRequestSpeed = 1L;
    private long mResponseSpeed = 1L;
    private AtomicBoolean mIsActive = new AtomicBoolean(false);

    public static WeakNetworkManager get() {
        return Holder.INSTANCE;
    }

    public boolean isActive() {
        return this.mIsActive.get();
    }

    public void setActive(boolean isActive) {
        this.mIsActive.set(isActive);
    }

    public void setParameter(long timeOutMillis, long requestSpeed, long responseSpeed) {
        if (timeOutMillis > 0L) {
            this.mTimeOutMillis = timeOutMillis;
        }
        this.mRequestSpeed = requestSpeed;
        this.mResponseSpeed = responseSpeed;
    }

    public void setType(int type) {
        this.mType = type;
    }

    public int getType() {
        return this.mType;
    }

    public long getTimeOutMillis() {
        return this.mTimeOutMillis;
    }

    public long getRequestSpeed() {
        return this.mRequestSpeed;
    }

    public long getResponseSpeed() {
        return this.mResponseSpeed;
    }

    public Response simulateOffNetwork(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        ResponseBody responseBody = ResponseBody.create((MediaType)response.body().contentType(), (String)"");
        Response newResponse = response.newBuilder().code(400).message(String.format("Unable to resolve host %s: No address associated with hostname", chain.request().url().host())).body(responseBody).build();
        return newResponse;
    }

    public Response simulateTimeOut(Interceptor.Chain chain) throws IOException {
        SystemClock.sleep((long)this.mTimeOutMillis);
        Response response = chain.proceed(chain.request());
        ResponseBody responseBody = ResponseBody.create((MediaType)response.body().contentType(), (String)"");
        Response newResponse = response.newBuilder().code(400).message(String.format("failed to connect to %s  after %dms", chain.request().url().host(), this.mTimeOutMillis)).body(responseBody).build();
        return newResponse;
    }

    public Response simulateSpeedLimit(Interceptor.Chain chain) throws IOException {
        Request request2 = chain.request();
        RequestBody body = request2.body();
        if (body != null) {
            RequestBody requestBody = this.mRequestSpeed > 0L ? new SpeedLimitRequestBody(this.mRequestSpeed, body) : body;
            request2 = request2.newBuilder().method(request2.method(), requestBody).build();
        }
        Response response = chain.proceed(request2);
        ResponseBody responseBody = response.body();
        ResponseBody newResponseBody = this.mResponseSpeed > 0L ? new SpeedLimitResponseBody(this.mResponseSpeed, responseBody) : responseBody;
        return response.newBuilder().body(newResponseBody).build();
    }

    private static class Holder {
        private static WeakNetworkManager INSTANCE = new WeakNetworkManager();

        private Holder() {
        }
    }
}

