/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.performance.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.performance.datasource.IDataSource;
import com.didichuxing.doraemonkit.kit.performance.widget.CardiogramView;

public class LineChart
extends FrameLayout {
    private TextView mTitle;
    private int performanceType;
    private CardiogramView mLine;

    public int getPerformanceType() {
        return this.performanceType;
    }

    public void setPerformanceType(int performanceType) {
        this.performanceType = performanceType;
    }

    public LineChart(@NonNull Context context) {
        super(context);
        this.initView(context);
    }

    public LineChart(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        LineChart.inflate((Context)context, (int)R.layout.dk_view_line_chart, (ViewGroup)this);
        this.mTitle = (TextView)this.findViewById(R.id.tv_title);
        this.mLine = (CardiogramView)this.findViewById(R.id.line_chart_view);
    }

    public void setTitle(String title) {
        this.mTitle.setText((CharSequence)title);
    }

    public void startMove() {
        this.mLine.startMove();
    }

    public void stopMove() {
        this.mLine.stopMove();
    }

    public void setInterval(int interval) {
        this.mLine.setInterval(interval);
    }

    public void setDataSource(@NonNull IDataSource dataSource) {
        this.mLine.setDataSource(dataSource);
    }
}

