/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.utils;

import android.content.Context;
import android.text.SpannableString;
import android.text.style.RelativeSizeSpan;
import com.didichuxing.doraemonkit.R;

public class CostTimeUtil {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;

    public static SpannableString formatTime(Context context, long time) {
        SpannableString spannableString;
        if (time == 0L) {
            RelativeSizeSpan sizeSpan = new RelativeSizeSpan(0.5f);
            spannableString = new SpannableString((CharSequence)context.getString(R.string.dk_network_summary_total_time_default));
            spannableString.setSpan((Object)sizeSpan, spannableString.length() - 1, spannableString.length(), 17);
        } else if (time < 100000L) {
            RelativeSizeSpan sizeSpan = new RelativeSizeSpan(0.5f);
            spannableString = new SpannableString((CharSequence)context.getString(R.string.dk_network_summary_total_time_second, new Object[]{time / 1000L}));
            spannableString.setSpan((Object)sizeSpan, spannableString.length() - 1, spannableString.length(), 17);
        } else if (time < 6000000L) {
            long minute = time / 60000L;
            long second = time % 60000L / 1000L;
            spannableString = new SpannableString((CharSequence)context.getString(R.string.dk_network_summary_total_time_minute, new Object[]{minute, second}));
            RelativeSizeSpan sizeSpan = new RelativeSizeSpan(0.5f);
            spannableString.setSpan((Object)sizeSpan, String.valueOf(minute).length(), String.valueOf(minute).length() + 1, 17);
            sizeSpan = new RelativeSizeSpan(0.5f);
            spannableString.setSpan((Object)sizeSpan, spannableString.length() - 1, spannableString.length(), 17);
        } else if (time < 360000000L) {
            long hour = time / 3600000L;
            long minute = time % 3600000L / 60000L;
            spannableString = new SpannableString((CharSequence)context.getString(R.string.dk_network_summary_total_time_hour, new Object[]{hour, minute}));
            RelativeSizeSpan sizeSpan = new RelativeSizeSpan(0.5f);
            spannableString.setSpan((Object)sizeSpan, String.valueOf(hour).length(), String.valueOf(hour).length() + 2, 17);
            sizeSpan = new RelativeSizeSpan(0.5f);
            spannableString.setSpan((Object)sizeSpan, spannableString.length() - 1, spannableString.length(), 17);
        } else {
            long day = time / 86400000L;
            long hour = time % 86400000L / 3600000L;
            spannableString = new SpannableString((CharSequence)context.getString(R.string.dk_network_summary_total_time_day, new Object[]{day, hour}));
            RelativeSizeSpan sizeSpan = new RelativeSizeSpan(0.5f);
            spannableString.setSpan((Object)sizeSpan, String.valueOf(day).length(), String.valueOf(day).length() + 1, 17);
            sizeSpan = new RelativeSizeSpan(0.5f);
            spannableString.setSpan((Object)sizeSpan, spannableString.length() - 2, spannableString.length(), 17);
        }
        return spannableString;
    }
}

