/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.ui;

import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.network.room_db.DokitDbManager;
import com.didichuxing.doraemonkit.kit.network.room_db.MockTemplateApiBean;
import com.didichuxing.doraemonkit.kit.network.ui.TemplateMockAdapter;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.volley.VolleyManager;
import com.didichuxing.doraemonkit.widget.jsonviewer.JsonRecyclerView;
import com.didichuxing.doraemonkit.widget.titlebar.HomeTitleBar;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class MockTemplatePreviewFragment
extends BaseFragment {
    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_mock_template_preview;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
    }

    private void initView() {
        if (this.getActivity() == null || DokitDbManager.getInstance().getGlobalTemplateApiBean() == null) {
            return;
        }
        HomeTitleBar homeTitleBar = (HomeTitleBar)((Object)this.findViewById(R.id.title_bar));
        homeTitleBar.setListener(new HomeTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                MockTemplatePreviewFragment.this.finish();
            }
        });
        TextView tvName = (TextView)this.findViewById(R.id.tv_name);
        TextView tvPath = (TextView)this.findViewById(R.id.tv_path);
        tvName.setText((CharSequence)String.format("mock api name:%s", DokitDbManager.getInstance().getGlobalTemplateApiBean().getMockApiName()));
        tvPath.setText((CharSequence)String.format("mock api path:%s", DokitDbManager.getInstance().getGlobalTemplateApiBean().getPath()));
        JsonRecyclerView jsonViewQuery = (JsonRecyclerView)((Object)this.findViewById(R.id.json_query));
        JsonRecyclerView jsonRecycleView = (JsonRecyclerView)((Object)this.findViewById(R.id.jsonviewer));
        TextView tvUpload = (TextView)this.findViewById(R.id.tv_upload);
        tvUpload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DokitDbManager.getInstance().getGlobalTemplateApiBean() == null) {
                    ToastUtils.showShort((CharSequence)"no mock template data");
                    return;
                }
                MockTemplateApiBean mockApi = DokitDbManager.getInstance().getGlobalTemplateApiBean();
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("projectId", mockApi.getProjectId());
                values.put("id", mockApi.getId());
                values.put("tempData", mockApi.getStrResponse());
                JsonObjectRequest request2 = new JsonObjectRequest(7, TemplateMockAdapter.TEMPLATER_UPLOAD_URL, new JSONObject(values), (Response.Listener)new Response.Listener<JSONObject>(){

                    public void onResponse(JSONObject response) {
                        ToastUtils.showShort((CharSequence)"upload template succeed");
                        LogHelper.i(MockTemplatePreviewFragment.this.TAG, "\u4e0a\u4f20\u6a21\u677f===>" + response.toString());
                    }
                }, new Response.ErrorListener(){

                    public void onErrorResponse(VolleyError error) {
                        ToastUtils.showShort((CharSequence)"upload template failed");
                        LogHelper.e(MockTemplatePreviewFragment.this.TAG, "error===>" + error.getMessage());
                    }
                });
                VolleyManager.INSTANCE.add(request2);
            }
        });
        if (DokitDbManager.getInstance().getGlobalTemplateApiBean() == null) {
            ToastUtils.showShort((CharSequence)"no mock template data");
            return;
        }
        try {
            JSONObject jsonQuery = new JSONObject(DokitDbManager.getInstance().getGlobalTemplateApiBean().getQuery());
            if (jsonQuery.length() == 0) {
                jsonViewQuery.setVisibility(8);
            } else {
                jsonViewQuery.setVisibility(0);
                jsonViewQuery.bindJson(jsonQuery);
            }
            new JSONObject(DokitDbManager.getInstance().getGlobalTemplateApiBean().getStrResponse());
            jsonRecycleView.setTextSize(16.0f);
            jsonRecycleView.bindJson(DokitDbManager.getInstance().getGlobalTemplateApiBean().getStrResponse());
        }
        catch (JSONException e) {
            e.printStackTrace();
            ToastUtils.showShort((CharSequence)"the data is not json");
        }
    }
}

