/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.kit.network.common.CommonHeaders;
import com.didichuxing.doraemonkit.kit.network.core.NetworkInterpreter;
import java.util.List;

public class CommonInspectorResponse
implements NetworkInterpreter.InspectorResponse {
    private final int mRequestId;
    private final String url;
    private final int statusCode;
    private final CommonHeaders headers;

    public CommonInspectorResponse(int requestId, @NonNull String url, int statusCode, @Nullable CommonHeaders headers) {
        this.mRequestId = requestId;
        this.url = url;
        this.statusCode = statusCode;
        this.headers = headers;
    }

    @Override
    public int requestId() {
        return this.mRequestId;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public int headerCount() {
        if (this.headers != null) {
            return this.headers.size();
        }
        return 0;
    }

    @Override
    public String headerName(int index) {
        if (this.headers != null) {
            return this.headers.name(index);
        }
        return null;
    }

    @Override
    public String headerValue(int index) {
        if (this.headers != null) {
            return this.headers.value(index);
        }
        return null;
    }

    @Override
    public String firstHeaderValue(String name) {
        List<String> values;
        if (this.headers != null && (values = this.headers.values(name)) != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }
}

