/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.layoutborder;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.fragment.app.Fragment;
import com.didichuxing.doraemonkit.kit.core.UniversalActivity;
import com.didichuxing.doraemonkit.kit.layoutborder.ViewBorderFrameLayout;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import com.didichuxing.doraemonkit.util.LifecycleListenerUtil;

public class LayoutBorderManager {
    private boolean isRunning;
    private ViewBorderFrameLayout mViewBorderFrameLayout;
    private LifecycleListenerUtil.LifecycleListener mLifecycleListener = new LifecycleListenerUtil.LifecycleListener(){

        @Override
        public void onActivityResumed(Activity activity) {
            LayoutBorderManager.this.resolveActivity(activity);
        }

        @Override
        public void onActivityPaused(Activity activity) {
        }

        @Override
        public void onFragmentAttached(Fragment f) {
        }

        @Override
        public void onFragmentDetached(Fragment f) {
            if (LayoutBorderManager.this.mViewBorderFrameLayout != null) {
                LayoutBorderManager.this.mViewBorderFrameLayout = null;
            }
        }
    };

    private void resolveActivity(Activity activity) {
        if (activity == null || activity instanceof UniversalActivity) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        ViewGroup root = (ViewGroup)window.getDecorView();
        if (root == null) {
            return;
        }
        this.mViewBorderFrameLayout = new ViewBorderFrameLayout(root.getContext());
        while (root.getChildCount() != 0) {
            View child = root.getChildAt(0);
            if (child instanceof ViewBorderFrameLayout) {
                this.mViewBorderFrameLayout = (ViewBorderFrameLayout)child;
                return;
            }
            root.removeView(child);
            this.mViewBorderFrameLayout.addView(child);
        }
        root.addView((View)this.mViewBorderFrameLayout);
    }

    private LayoutBorderManager() {
    }

    public static LayoutBorderManager getInstance() {
        return Holder.INSTANCE;
    }

    public void start() {
        this.isRunning = true;
        this.resolveActivity(ActivityUtils.getTopActivity());
        LifecycleListenerUtil.registerListener(this.mLifecycleListener);
    }

    public void stop() {
        this.isRunning = false;
        if (this.mViewBorderFrameLayout != null) {
            this.mViewBorderFrameLayout.requestLayout();
        }
        this.mViewBorderFrameLayout = null;
        LifecycleListenerUtil.unRegisterListener(this.mLifecycleListener);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private static class Holder {
        private static LayoutBorderManager INSTANCE = new LayoutBorderManager();

        private Holder() {
        }
    }
}

