/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.largepicture;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.config.PerformanceSpInfoConfig;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.largepicture.LargeImageInfo;
import com.didichuxing.doraemonkit.kit.largepicture.LargeImageListAdapter;
import com.didichuxing.doraemonkit.kit.largepicture.LargePictureManager;
import com.didichuxing.doraemonkit.widget.recyclerview.DividerItemDecoration;
import com.didichuxing.doraemonkit.widget.titlebar.TitleBar;
import java.util.ArrayList;

public class LargeImageListFragment
extends BaseFragment {
    private static final String TAG = "LargeImageListFragment";
    private RecyclerView mLargeImageList;
    private LargeImageListAdapter mLargeImageListAdapter;
    private TitleBar mTitleBar;
    private double fileThreshold = PerformanceSpInfoConfig.getLargeImgFileThreshold(LargePictureManager.FILE_DEFAULT_THRESHOLD);
    private double memoryThreshold = PerformanceSpInfoConfig.getLargeImgMemoryThreshold(LargePictureManager.MEMORY_DEFAULT_THRESHOLD);

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_large_img_list;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
        this.load();
    }

    private void initView() {
        this.mLargeImageList = (RecyclerView)this.findViewById(R.id.block_list);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mLargeImageList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mLargeImageListAdapter = new LargeImageListAdapter(this.getContext());
        this.mLargeImageList.setAdapter((RecyclerView.Adapter)this.mLargeImageListAdapter);
        DividerItemDecoration decoration = new DividerItemDecoration(1);
        decoration.setDrawable(this.getResources().getDrawable(R.drawable.dk_divider));
        this.mLargeImageList.addItemDecoration((RecyclerView.ItemDecoration)decoration);
        this.mTitleBar = (TitleBar)((Object)this.findViewById(R.id.title_bar));
        this.mTitleBar.setOnTitleBarClickListener(new TitleBar.OnTitleBarClickListener(){

            @Override
            public void onLeftClick() {
                LargeImageListFragment.this.getActivity().onBackPressed();
            }

            @Override
            public void onRightClick() {
            }
        });
    }

    private void load() {
        ArrayList<LargeImageInfo> imageInfos = new ArrayList<LargeImageInfo>();
        for (LargeImageInfo largeImageInfo : LargePictureManager.LARGE_IMAGE_INFO_MAP.values()) {
            if (largeImageInfo.getFileSize() < this.fileThreshold && largeImageInfo.getMemorySize() < this.memoryThreshold) continue;
            imageInfos.add(largeImageInfo);
        }
        this.mLargeImageListAdapter.setData(imageInfos);
    }

    public void onDestroyView() {
        super.onDestroyView();
    }
}

