/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.health;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Process;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.config.GlobalConfig;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.health.AppHealthInfoUtil;
import com.didichuxing.doraemonkit.kit.health.UploadAppHealthCallback;
import com.didichuxing.doraemonkit.kit.health.UserInfoDialogProvider;
import com.didichuxing.doraemonkit.util.AppUtils;
import com.didichuxing.doraemonkit.util.DoKitCommUtil;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.dialog.DialogListener;
import com.didichuxing.doraemonkit.widget.dialog.DialogProvider;
import com.didichuxing.doraemonkit.widget.dialog.UniversalDialogFragment;

public class HealthFragmentChild0
extends BaseFragment {
    TextView mTitle;
    ImageView mController;
    UserInfoDialogProvider mUserInfoDialogProvider;

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_health_child0;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.getActivity() == null) {
            return;
        }
        this.mTitle = (TextView)this.findViewById(R.id.tv_title);
        this.mController = (ImageView)this.findViewById(R.id.iv_btn);
        if (DoKitManager.APP_HEALTH_RUNNING) {
            this.mTitle.setVisibility(0);
            this.mController.setImageResource(R.mipmap.dk_health_stop);
        } else {
            this.mTitle.setVisibility(4);
            this.mController.setImageResource(R.mipmap.dk_health_start);
        }
        this.mUserInfoDialogProvider = new UserInfoDialogProvider<Object>(null, new DialogListener(){

            @Override
            public boolean onPositive(DialogProvider<?> dialogProvider) {
                if (HealthFragmentChild0.this.mUserInfoDialogProvider != null) {
                    boolean isCheck = HealthFragmentChild0.this.mUserInfoDialogProvider.uploadAppHealthInfo(new UploadAppHealthCallback(){

                        @Override
                        public void onSuccess(String response) {
                            LogHelper.i(HealthFragmentChild0.this.TAG, "\u4e0a\u4f20\u6210\u529f===>" + response);
                            ToastUtils.showShort((CharSequence)DoKitCommUtil.getString(R.string.dk_health_upload_successed));
                            GlobalConfig.setAppHealth(false);
                            DoKitManager.APP_HEALTH_RUNNING = false;
                            HealthFragmentChild0.this.mTitle.setVisibility(4);
                            HealthFragmentChild0.this.mController.setImageResource(R.mipmap.dk_health_start);
                            AppHealthInfoUtil.getInstance().stop();
                            AppHealthInfoUtil.getInstance().release();
                        }

                        @Override
                        public void onError(String response) {
                            LogHelper.e(HealthFragmentChild0.this.TAG, "error response===>" + response);
                            ToastUtils.showShort((CharSequence)DoKitCommUtil.getString(R.string.dk_health_upload_failed));
                        }
                    });
                    return isCheck;
                }
                return true;
            }

            @Override
            public boolean onNegative(DialogProvider<?> dialogProvider) {
                return true;
            }

            @Override
            public void onCancel(DialogProvider<?> dialogProvider) {
                ToastUtils.showShort((CharSequence)DoKitCommUtil.getString(R.string.dk_health_upload_droped));
                GlobalConfig.setAppHealth(false);
                DoKitManager.APP_HEALTH_RUNNING = false;
                HealthFragmentChild0.this.mTitle.setVisibility(4);
                HealthFragmentChild0.this.mController.setImageResource(R.mipmap.dk_health_start);
                AppHealthInfoUtil.getInstance().stop();
                AppHealthInfoUtil.getInstance().release();
            }
        });
        this.mController.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (HealthFragmentChild0.this.getActivity() == null) {
                    return;
                }
                if (DoKitManager.APP_HEALTH_RUNNING) {
                    if (HealthFragmentChild0.this.mUserInfoDialogProvider != null) {
                        HealthFragmentChild0.this.showDialog((DialogProvider)HealthFragmentChild0.this.mUserInfoDialogProvider);
                    }
                } else {
                    new AlertDialog.Builder((Context)HealthFragmentChild0.this.getActivity()).setTitle((CharSequence)DoKitCommUtil.getString(R.string.dk_health_upload_title)).setMessage((CharSequence)DoKitCommUtil.getString(R.string.dk_health_upload_message)).setCancelable(false).setPositiveButton((CharSequence)"ok", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            if (HealthFragmentChild0.this.mController != null) {
                                ToastUtils.showShort((CharSequence)DoKitCommUtil.getString(R.string.dk_health_funcation_start));
                                GlobalConfig.setAppHealth(true);
                                DoKitManager.APP_HEALTH_RUNNING = true;
                                HealthFragmentChild0.this.mController.postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                        AppUtils.relaunchApp();
                                        Process.killProcess((int)Process.myPid());
                                        System.exit(1);
                                    }
                                }, 2000L);
                            }
                        }
                    }).setNegativeButton((CharSequence)"cancel", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    }).show();
                }
            }
        });
    }

    public void showDialog(DialogProvider provider) {
        UniversalDialogFragment dialog = new UniversalDialogFragment();
        provider.setHost(dialog);
        dialog.setProvider(provider);
        provider.show(this.getChildFragmentManager());
    }
}

