/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.health;

import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.didichuxing.doraemonkit.config.CrashCaptureConfig;
import com.didichuxing.doraemonkit.kit.blockmonitor.core.BlockMonitorManager;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.crash.CrashCaptureManager;
import com.didichuxing.doraemonkit.kit.health.UploadAppHealthCallback;
import com.didichuxing.doraemonkit.kit.health.model.AppHealthInfo;
import com.didichuxing.doraemonkit.kit.performance.PerformanceDataManager;
import com.didichuxing.doraemonkit.util.AppUtils;
import com.didichuxing.doraemonkit.util.DeviceUtils;
import com.didichuxing.doraemonkit.util.GsonUtils;
import com.didichuxing.doraemonkit.util.TimeUtils;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.volley.VolleyManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.json.JSONObject;

public class AppHealthInfoUtil {
    private static String TAG = "AppHealthInfoUtil";
    private AppHealthInfo mAppHealthInfo = new AppHealthInfo();

    public static AppHealthInfoUtil getInstance() {
        return Holder.INSTANCE;
    }

    void setBaseInfo(String caseName, String testPerson) {
        AppHealthInfo.BaseInfoBean baseInfoBean = new AppHealthInfo.BaseInfoBean();
        baseInfoBean.setTestPerson(testPerson);
        baseInfoBean.setCaseName(caseName);
        baseInfoBean.setAppName(AppUtils.getAppName());
        baseInfoBean.setAppVersion(AppUtils.getAppVersionName());
        baseInfoBean.setDokitVersion("3.5.0");
        baseInfoBean.setPlatform("Android");
        baseInfoBean.setPhoneMode(DeviceUtils.getModel());
        baseInfoBean.setTime(TimeUtils.getNowString());
        baseInfoBean.setSystemVersion(DeviceUtils.getSDKVersionName());
        baseInfoBean.setpId("" + DoKitManager.PRODUCT_ID);
        this.mAppHealthInfo.setBaseInfo(baseInfoBean);
    }

    public void setAppStartInfo(long costTime, String costDetail, List<AppHealthInfo.DataBean.AppStartBean.LoadFuncBean> loadFunc) {
        AppHealthInfo.DataBean.AppStartBean appStartBean = new AppHealthInfo.DataBean.AppStartBean();
        appStartBean.setCostTime(costTime);
        appStartBean.setCostDetail(costDetail);
        appStartBean.setLoadFunc(loadFunc);
        this.getData().setAppStart(appStartBean);
    }

    public void addCPUInfo(AppHealthInfo.DataBean.PerformanceBean cpuBean) {
        List<AppHealthInfo.DataBean.PerformanceBean> cpus = this.getData().getCpu();
        if (cpus == null) {
            cpus = new ArrayList<AppHealthInfo.DataBean.PerformanceBean>();
            this.getData().setCpu(cpus);
        }
        cpus.add(cpuBean);
    }

    public void addMemoryInfo(AppHealthInfo.DataBean.PerformanceBean memoryBean) {
        List<AppHealthInfo.DataBean.PerformanceBean> memories = this.getData().getMemory();
        if (memories == null) {
            memories = new ArrayList<AppHealthInfo.DataBean.PerformanceBean>();
            this.getData().setMemory(memories);
        }
        memories.add(memoryBean);
    }

    public void addFPSInfo(AppHealthInfo.DataBean.PerformanceBean fpsBean) {
        List<AppHealthInfo.DataBean.PerformanceBean> fpsBeans = this.getData().getFps();
        if (fpsBeans == null) {
            fpsBeans = new ArrayList<AppHealthInfo.DataBean.PerformanceBean>();
            this.getData().setFps(fpsBeans);
        }
        fpsBeans.add(fpsBean);
    }

    public AppHealthInfo.DataBean.PerformanceBean getLastPerformanceInfo(int performanceType) {
        List<AppHealthInfo.DataBean.PerformanceBean> performanceBeans = null;
        if (performanceType == 1) {
            performanceBeans = this.getData().getCpu();
        } else if (performanceType == 2) {
            performanceBeans = this.getData().getMemory();
        } else if (performanceType == 3) {
            performanceBeans = this.getData().getFps();
        }
        if (performanceBeans == null || performanceBeans.size() == 0) {
            return null;
        }
        return performanceBeans.get(performanceBeans.size() - 1);
    }

    public void removeLastPerformanceInfo(int performanceType) {
        List<AppHealthInfo.DataBean.PerformanceBean> performanceBeans = null;
        if (performanceType == 1) {
            performanceBeans = this.getData().getCpu();
        } else if (performanceType == 2) {
            performanceBeans = this.getData().getMemory();
        } else if (performanceType == 3) {
            performanceBeans = this.getData().getFps();
        }
        if (performanceBeans != null && performanceBeans.size() > 0) {
            performanceBeans.remove(performanceBeans.size() - 1);
        }
    }

    public void addNetWorkInfo(AppHealthInfo.DataBean.NetworkBean networkBean) {
        List<AppHealthInfo.DataBean.NetworkBean> networks = this.getData().getNetwork();
        if (networks == null) {
            networks = new ArrayList<AppHealthInfo.DataBean.NetworkBean>();
            this.getData().setNetwork(networks);
        }
        networks.add(networkBean);
    }

    public AppHealthInfo.DataBean.NetworkBean getNetWorkInfo(String activityName) {
        List<AppHealthInfo.DataBean.NetworkBean> networks = this.getData().getNetwork();
        if (networks == null || networks.size() == 0) {
            return null;
        }
        AppHealthInfo.DataBean.NetworkBean networkBean = null;
        for (AppHealthInfo.DataBean.NetworkBean traverseNetworkBean : networks) {
            if (!traverseNetworkBean.getPage().equals(activityName)) continue;
            networkBean = traverseNetworkBean;
            break;
        }
        return networkBean;
    }

    public void addBlockInfo(AppHealthInfo.DataBean.BlockBean blockBean) {
        List<AppHealthInfo.DataBean.BlockBean> blocks = this.getData().getBlock();
        if (blocks == null) {
            blocks = new ArrayList<AppHealthInfo.DataBean.BlockBean>();
            this.getData().setBlock(blocks);
        }
        blocks.add(blockBean);
    }

    public void addUiLevelInfo(AppHealthInfo.DataBean.UiLevelBean uiLevelBean) {
        List<AppHealthInfo.DataBean.UiLevelBean> uiLevels = this.getData().getUiLevel();
        if (uiLevels == null) {
            uiLevels = new ArrayList<AppHealthInfo.DataBean.UiLevelBean>();
            this.getData().setUiLevel(uiLevels);
        }
        uiLevels.add(uiLevelBean);
    }

    public void addLeakInfo(AppHealthInfo.DataBean.LeakBean leakBean) {
        List<AppHealthInfo.DataBean.LeakBean> leaks = this.getData().getLeak();
        if (leaks == null) {
            leaks = new ArrayList<AppHealthInfo.DataBean.LeakBean>();
            this.getData().setLeak(leaks);
        }
        leaks.add(leakBean);
    }

    public void addPageLoadInfo(AppHealthInfo.DataBean.PageLoadBean pageLoadBean) {
        List<AppHealthInfo.DataBean.PageLoadBean> pageloads = this.getData().getPageLoad();
        if (pageloads == null) {
            pageloads = new ArrayList<AppHealthInfo.DataBean.PageLoadBean>();
            this.getData().setPageLoad(pageloads);
        }
        pageloads.add(pageLoadBean);
    }

    public void addBigFilrInfo(AppHealthInfo.DataBean.BigFileBean bigFileBean) {
        List<AppHealthInfo.DataBean.BigFileBean> bigFiles = this.getData().getBigFile();
        if (bigFiles == null) {
            bigFiles = new ArrayList<AppHealthInfo.DataBean.BigFileBean>();
            this.getData().setBigFile(bigFiles);
        }
        bigFiles.add(bigFileBean);
    }

    public void post(final UploadAppHealthCallback uploadAppHealthCallBack) throws Exception {
        if (this.mAppHealthInfo == null) {
            return;
        }
        JsonObjectRequest request2 = new JsonObjectRequest(1, "https://www.dokit.cn/healthCheck/addCheckData", new JSONObject(GsonUtils.toJson((Object)this.mAppHealthInfo)), (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                if (uploadAppHealthCallBack != null) {
                    uploadAppHealthCallBack.onSuccess(response.toString());
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (uploadAppHealthCallBack != null) {
                    uploadAppHealthCallBack.onError(error.getMessage());
                }
            }
        });
        VolleyManager.INSTANCE.add(request2);
    }

    private AppHealthInfo.DataBean getData() {
        if (this.mAppHealthInfo.getData() == null) {
            AppHealthInfo.DataBean dataBean = new AppHealthInfo.DataBean();
            dataBean.setCpu(new ArrayList<AppHealthInfo.DataBean.PerformanceBean>());
            dataBean.setMemory(new ArrayList<AppHealthInfo.DataBean.PerformanceBean>());
            dataBean.setFps(new ArrayList<AppHealthInfo.DataBean.PerformanceBean>());
            dataBean.setNetwork(new ArrayList<AppHealthInfo.DataBean.NetworkBean>());
            dataBean.setBlock(new ArrayList<AppHealthInfo.DataBean.BlockBean>());
            dataBean.setUiLevel(new ArrayList<AppHealthInfo.DataBean.UiLevelBean>());
            dataBean.setLeak(new ArrayList<AppHealthInfo.DataBean.LeakBean>());
            dataBean.setPageLoad(new ArrayList<AppHealthInfo.DataBean.PageLoadBean>());
            dataBean.setBigFile(new ArrayList<AppHealthInfo.DataBean.BigFileBean>());
            dataBean.setSubThreadUI(new ArrayList<AppHealthInfo.DataBean.SubThreadUIBean>());
            this.mAppHealthInfo.setData(dataBean);
        }
        return this.mAppHealthInfo.getData();
    }

    public boolean isAppHealthRunning() {
        boolean isRunning = DoKitManager.APP_HEALTH_RUNNING;
        if (isRunning) {
            ToastUtils.showShort((CharSequence)"App\u5f53\u524d\u5904\u4e8e\u5065\u5eb7\u4f53\u68c0\u72b6\u6001,\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c");
        }
        return isRunning;
    }

    public void start() {
        PerformanceDataManager.getInstance().init();
        PerformanceDataManager.getInstance().startMonitorFrameInfo();
        PerformanceDataManager.getInstance().startMonitorCPUInfo();
        PerformanceDataManager.getInstance().startMonitorMemoryInfo();
        PerformanceDataManager.getInstance().startMonitorNetFlowInfo();
        BlockMonitorManager.getInstance().start();
        CrashCaptureConfig.setCrashCaptureOpen(true);
        CrashCaptureManager.getInstance().start();
    }

    public void stop() {
        PerformanceDataManager.getInstance().stopMonitorFrameInfo();
        PerformanceDataManager.getInstance().stopMonitorCPUInfo();
        PerformanceDataManager.getInstance().stopMonitorMemoryInfo();
        PerformanceDataManager.getInstance().stopMonitorNetFlowInfo();
        BlockMonitorManager.getInstance().stop();
        CrashCaptureConfig.setCrashCaptureOpen(false);
        CrashCaptureManager.getInstance().stop();
    }

    private List<AppHealthInfo.DataBean.PerformanceBean.ValuesBean> sortValue(List<AppHealthInfo.DataBean.PerformanceBean.ValuesBean> valuesBeans) {
        ArrayList<AppHealthInfo.DataBean.PerformanceBean.ValuesBean> newValuesBeans = new ArrayList<AppHealthInfo.DataBean.PerformanceBean.ValuesBean>(valuesBeans);
        Collections.sort(newValuesBeans, new Comparator<AppHealthInfo.DataBean.PerformanceBean.ValuesBean>(){

            @Override
            public int compare(AppHealthInfo.DataBean.PerformanceBean.ValuesBean pre, AppHealthInfo.DataBean.PerformanceBean.ValuesBean next) {
                float nextValue;
                float preValue = Float.parseFloat(pre.getValue());
                if (preValue < (nextValue = Float.parseFloat(next.getValue()))) {
                    return -1;
                }
                return 1;
            }
        });
        newValuesBeans.remove(0);
        newValuesBeans.remove(newValuesBeans.size() - 1);
        Collections.sort(newValuesBeans, new Comparator<AppHealthInfo.DataBean.PerformanceBean.ValuesBean>(){

            @Override
            public int compare(AppHealthInfo.DataBean.PerformanceBean.ValuesBean pre, AppHealthInfo.DataBean.PerformanceBean.ValuesBean next) {
                long nextValue;
                long preValue = Long.parseLong(pre.getTime());
                if (preValue < (nextValue = Long.parseLong(next.getTime()))) {
                    return -1;
                }
                return 1;
            }
        });
        return newValuesBeans;
    }

    public void release() {
        if (this.mAppHealthInfo != null) {
            this.mAppHealthInfo = null;
        }
    }

    private static class Holder {
        private static AppHealthInfoUtil INSTANCE = new AppHealthInfoUtil();

        private Holder() {
        }
    }
}

