/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.aop.urlconnection;

import android.net.Uri;
import com.didichuxing.doraemonkit.aop.urlconnection.ObsoleteUrlFactory;
import com.didichuxing.doraemonkit.aop.urlconnection.OkhttpClientUtil;
import com.didichuxing.doraemonkit.kit.network.okhttp.interceptor.DokitCapInterceptor;
import com.didichuxing.doraemonkit.kit.network.okhttp.interceptor.DokitExtInterceptor;
import com.didichuxing.doraemonkit.kit.network.okhttp.interceptor.DokitLargePicInterceptor;
import com.didichuxing.doraemonkit.kit.network.okhttp.interceptor.DokitMockInterceptor;
import com.didichuxing.doraemonkit.kit.network.okhttp.interceptor.DokitWeakNetworkInterceptor;
import java.net.URL;
import java.net.URLConnection;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class HttpUrlConnectionProxyUtil {
    private static String[] hosts = new String[]{"amap.com"};

    public static URLConnection proxy(URLConnection urlConnection) {
        try {
            String host = HttpUrl.parse((String)urlConnection.getURL().toString()).host();
            if (HttpUrlConnectionProxyUtil.isIgnore(host)) {
                return urlConnection;
            }
            return HttpUrlConnectionProxyUtil.createOkHttpURLConnection(urlConnection);
        }
        catch (Exception e) {
            e.printStackTrace();
            return urlConnection;
        }
    }

    private static URLConnection createOkHttpURLConnection(URLConnection urlConnection) throws Exception {
        String strUrl = HttpUrlConnectionProxyUtil.encodeUrl(urlConnection.getURL().toString());
        URL url = new URL(strUrl);
        String protocol = url.getProtocol().toLowerCase();
        if (protocol.equalsIgnoreCase("http")) {
            return new ObsoleteUrlFactory.OkHttpURLConnection(url, OkhttpClientUtil.INSTANCE.getOkhttpClient());
        }
        if (protocol.equalsIgnoreCase("https")) {
            return new ObsoleteUrlFactory.OkHttpsURLConnection(url, OkhttpClientUtil.INSTANCE.getOkhttpClient());
        }
        return urlConnection;
    }

    public static String encodeUrl(String url) {
        return Uri.encode((String)url, (String)"-![.:/,%?&=]");
    }

    public static String decodeUrl(String url) {
        return Uri.decode((String)url);
    }

    private static void addInterceptor(OkHttpClient.Builder builder) {
        for (Interceptor interceptor : builder.interceptors()) {
            if (!(interceptor instanceof DokitMockInterceptor)) continue;
            return;
        }
        builder.addInterceptor((Interceptor)new DokitMockInterceptor()).addInterceptor((Interceptor)new DokitLargePicInterceptor()).addInterceptor((Interceptor)new DokitCapInterceptor()).addNetworkInterceptor((Interceptor)new DokitWeakNetworkInterceptor()).addInterceptor((Interceptor)new DokitExtInterceptor());
    }

    private static boolean isIgnore(String host) {
        for (String jumpHost : hosts) {
            if (!host.contains(jumpHost)) continue;
            return true;
        }
        return false;
    }
}

