/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.tableview.bean;

import android.graphics.Paint;
import com.didichuxing.doraemonkit.widget.tableview.format.FastTextDrawFormat;
import com.didichuxing.doraemonkit.widget.tableview.intface.IDrawFormat;
import com.didichuxing.doraemonkit.widget.tableview.intface.IFormat;
import com.didichuxing.doraemonkit.widget.tableview.listener.OnColumnItemClickListener;
import java.util.ArrayList;
import java.util.List;

public class Column<T>
implements Comparable<Column> {
    public static final String INVAL_VALUE = "";
    private String columnName;
    private IFormat<T> format;
    private IDrawFormat<T> drawFormat = new FastTextDrawFormat();
    private List<T> datas;
    private boolean isFixed;
    private int computeWidth;
    private OnColumnItemClickListener<T> onColumnItemClickListener;
    private Paint.Align textAlign;
    private Paint.Align titleAlign;
    private int id;
    private int minWidth;
    private int minHeight;
    private int width;

    public Column(String columnName, IFormat<T> format, IDrawFormat<T> drawFormat) {
        this.columnName = columnName;
        this.format = format;
        if (drawFormat != null) {
            this.drawFormat = drawFormat;
        }
        this.datas = new ArrayList<T>();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public IFormat<T> getFormat() {
        return this.format;
    }

    public void setFormat(IFormat<T> format) {
        this.format = format;
    }

    public IDrawFormat<T> getDrawFormat() {
        return this.drawFormat;
    }

    public void setDrawFormat(IDrawFormat<T> drawFormat) {
        this.drawFormat = drawFormat;
    }

    public List<T> getDatas() {
        return this.datas;
    }

    public void setDatas(List<T> datas) {
        this.datas = datas;
    }

    public String format(int position) {
        if (position >= 0 && position < this.datas.size()) {
            return this.format(this.datas.get(position));
        }
        return INVAL_VALUE;
    }

    public String format(T t) {
        String value = this.format != null ? this.format.format(t) : (t == null ? INVAL_VALUE : t.toString());
        return value;
    }

    public int getComputeWidth() {
        return this.computeWidth;
    }

    public void setComputeWidth(int computeWidth) {
        this.computeWidth = computeWidth;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id2) {
        this.id = id2;
    }

    @Override
    public int compareTo(Column o) {
        return this.id - o.getId();
    }

    public OnColumnItemClickListener<T> getOnColumnItemClickListener() {
        return this.onColumnItemClickListener;
    }

    public void setOnColumnItemClickListener(OnColumnItemClickListener<T> onColumnItemClickListener) {
        this.onColumnItemClickListener = onColumnItemClickListener;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setFixed(boolean fixed) {
        this.isFixed = fixed;
    }

    public Paint.Align getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(Paint.Align textAlign) {
        this.textAlign = textAlign;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public Paint.Align getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(Paint.Align titleAlign) {
        this.titleAlign = titleAlign;
    }

    public void setWidth(int width) {
        if (width > 0) {
            this.width = width;
            this.setDrawFormat(new FastTextDrawFormat());
        }
    }

    public int getWidth() {
        if (this.width == 0) {
            return this.computeWidth;
        }
        return this.width;
    }
}

