/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.bottomview;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.widget.bottomview.AssociationView;

public class BottomUpWindow
extends PopupWindow {
    private final String TAG = "BottomUpSelectWindow";
    private View thisView;
    private View tv_submit;
    private final View titleViiew;
    private FrameLayout contentPanel;
    private AssociationView associationView;
    private View ll_panel;
    private View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            int vid = v.getId();
            if (vid == R.id.tv_submit) {
                Object submit = BottomUpWindow.this.associationView.submit();
                if (BottomUpWindow.this.mOnSubmitListener != null) {
                    BottomUpWindow.this.mOnSubmitListener.submit(submit);
                }
                BottomUpWindow.this.dismiss();
            } else if (vid == R.id.tv_cancel) {
                BottomUpWindow.this.cancel();
            }
        }
    };
    private OnSubmitListener mOnSubmitListener;

    public BottomUpWindow(Context context) {
        super(context);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.thisView = layoutInflater.inflate(R.layout.dk_item_layout_bottom_up_select_window, null);
        this.ll_panel = this.thisView.findViewById(R.id.ll_panel);
        this.titleViiew = this.thisView.findViewById(R.id.tv_title);
        this.contentPanel = (FrameLayout)this.thisView.findViewById(R.id.content);
        this.setContentView(this.thisView);
        this.initView();
        this.setWidth(-1);
        this.setHeight(-2);
        this.setFocusable(true);
        this.setTouchable(true);
        this.setOutsideTouchable(true);
        ColorDrawable dw = new ColorDrawable(Integer.MIN_VALUE);
        this.setBackgroundDrawable((Drawable)dw);
    }

    private void initView() {
        this.tv_submit = this.thisView.findViewById(R.id.tv_submit);
        this.tv_submit.setOnClickListener(this.onClickListener);
        this.thisView.findViewById(R.id.tv_cancel).setOnClickListener(this.onClickListener);
        this.thisView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BottomUpWindow.this.cancel();
            }
        });
    }

    public BottomUpWindow setContent(AssociationView view) {
        this.associationView = view;
        this.contentPanel.removeAllViews();
        this.contentPanel.addView(this.associationView.getView());
        this.associationView.setOnStateChangeListener(new AssociationView.OnStateChangeListener(){

            @Override
            public void onStateChanged() {
                BottomUpWindow.this.tv_submit.setEnabled(BottomUpWindow.this.associationView.isCanSubmit());
            }
        });
        return this;
    }

    public void dismiss() {
        TranslateAnimation animation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
        animation.setDuration(200L);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                BottomUpWindow.this.ll_panel.setVisibility(8);
                BottomUpWindow.this.dismissWindow();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.ll_panel.startAnimation((Animation)animation);
        if (this.associationView != null) {
            this.associationView.onHide();
        }
    }

    private void dismissWindow() {
        try {
            super.dismiss();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void cancel() {
        this.associationView.cancel();
        this.dismiss();
        if (this.mOnSubmitListener != null) {
            this.mOnSubmitListener.cancel();
        }
    }

    public BottomUpWindow show(View parent) {
        this.showAtLocation(parent, 81, 0, 0);
        this.ll_panel.setVisibility(0);
        TranslateAnimation animation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
        animation.setDuration(200L);
        this.ll_panel.startAnimation((Animation)animation);
        if (this.associationView != null) {
            this.associationView.onShow();
        }
        return this;
    }

    public void setOnSubmitListener(OnSubmitListener onSubmitListener) {
        this.mOnSubmitListener = onSubmitListener;
    }

    public static interface OnSubmitListener {
        public void submit(Object var1);

        public void cancel();
    }
}

