/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.content.Context;
import android.graphics.Paint;
import android.view.View;

public class DoKitMiscUtil {
    public static int measure(int measureSpec, int defaultSize) {
        int result2 = defaultSize;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result2 = specSize;
        } else if (specMode == Integer.MIN_VALUE) {
            result2 = Math.min(result2, specSize);
        }
        return result2;
    }

    public static int dipToPx(Context context, float dip) {
        float density = context.getResources().getDisplayMetrics().density;
        return (int)(dip * density + 0.5f * (float)(dip >= 0.0f ? 1 : -1));
    }

    public static String getPrecisionFormat(int precision) {
        return "%." + precision + "f";
    }

    public static <T> T[] reverse(T[] arrays) {
        if (arrays == null) {
            return null;
        }
        int length = arrays.length;
        for (int i = 0; i < length / 2; ++i) {
            T t = arrays[i];
            arrays[i] = arrays[length - i - 1];
            arrays[length - i - 1] = t;
        }
        return arrays;
    }

    public static float measureTextHeight(Paint paint) {
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        return Math.abs(fontMetrics.ascent) - fontMetrics.descent;
    }
}

