/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.webdoor;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.webdoor.WebDoorHistoryAdapter;
import com.didichuxing.doraemonkit.kit.webdoor.WebDoorManager;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.recyclerview.DividerItemDecoration;
import com.didichuxing.doraemonkit.widget.titlebar.HomeTitleBar;
import com.didichuxing.doraemonkit.zxing.activity.CaptureActivity;
import java.util.ArrayList;

public class WebDoorFragment
extends BaseFragment {
    private EditText mWebAddressInput;
    private TextView mUrlExplore;
    private RecyclerView mHistoryList;
    private WebDoorHistoryAdapter mWebDoorHistoryAdapter;
    private static final int REQUEST_CAMERA = 2;
    private static final int REQUEST_QR_CODE = 3;
    private static final String[] PERMISSIONS_CAMERA = new String[]{"android.permission.CAMERA"};

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_web_door;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        HomeTitleBar titleBar = (HomeTitleBar)((Object)this.findViewById(R.id.title_bar));
        titleBar.setListener(new HomeTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                WebDoorFragment.this.finish();
            }
        });
        this.mWebAddressInput = (EditText)this.findViewById(R.id.web_address_input);
        this.mWebAddressInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (WebDoorFragment.this.checkInput()) {
                    WebDoorFragment.this.mUrlExplore.setEnabled(true);
                } else {
                    WebDoorFragment.this.mUrlExplore.setEnabled(false);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.mUrlExplore = (TextView)this.findViewById(R.id.url_explore);
        this.findViewById(R.id.clear).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WebDoorManager.getInstance().clearHistory();
                WebDoorFragment.this.mWebDoorHistoryAdapter.clear();
            }
        });
        this.findViewById(R.id.qr_code).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WebDoorFragment.this.qrCode();
            }
        });
        this.mUrlExplore.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WebDoorFragment.this.doSearch(WebDoorFragment.this.mWebAddressInput.getText().toString());
            }
        });
        this.mHistoryList = (RecyclerView)this.findViewById(R.id.history_list);
        this.mHistoryList.setNestedScrollingEnabled(false);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mHistoryList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        ArrayList<String> historyItems = WebDoorManager.getInstance().getHistory();
        this.mWebDoorHistoryAdapter = new WebDoorHistoryAdapter(this.getContext());
        this.mWebDoorHistoryAdapter.setData(historyItems);
        this.mWebDoorHistoryAdapter.setOnItemClickListener(new WebDoorHistoryAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(View view, String data) {
                WebDoorFragment.this.doSearch(data);
            }
        });
        this.mHistoryList.setAdapter((RecyclerView.Adapter)this.mWebDoorHistoryAdapter);
        DividerItemDecoration decoration = new DividerItemDecoration(1);
        decoration.setDrawable(this.getResources().getDrawable(R.drawable.dk_divider));
        this.mHistoryList.addItemDecoration((RecyclerView.ItemDecoration)decoration);
    }

    private void doSearch(String url) {
        WebDoorManager.getInstance().saveHistory(url);
        WebDoorManager.getInstance().getWebDoorCallback().overrideUrlLoading(this.getContext(), url);
        this.mWebDoorHistoryAdapter.setData(WebDoorManager.getInstance().getHistory());
    }

    private boolean checkInput() {
        return !TextUtils.isEmpty((CharSequence)this.mWebAddressInput.getText());
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Bundle bundle;
        String result2;
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1 && requestCode == 3 && !TextUtils.isEmpty((CharSequence)(result2 = (bundle = data.getExtras()).getString("result")))) {
            this.doSearch(result2);
        }
    }

    private void qrCode() {
        if (!this.ownPermissionCheck()) {
            this.requestPermissions(PERMISSIONS_CAMERA, 2);
            return;
        }
        Intent intent = new Intent((Context)this.getActivity(), CaptureActivity.class);
        this.startActivityForResult(intent, 3);
    }

    private boolean ownPermissionCheck() {
        int permission2 = ActivityCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.CAMERA");
        return permission2 == 0;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 2) {
            for (int grantResult : grantResults) {
                if (grantResult != -1) continue;
                ToastUtils.showShort((int)R.string.dk_error_tips_permissions_less);
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }
}

