/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.room_db;

import android.text.TextUtils;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.core.DokitViewManager;
import com.didichuxing.doraemonkit.kit.network.room_db.AbsMockApiBean;
import com.didichuxing.doraemonkit.kit.network.room_db.DokitDatabase;
import com.didichuxing.doraemonkit.kit.network.room_db.MockInterceptApiBean;
import com.didichuxing.doraemonkit.kit.network.room_db.MockTemplateApiBean;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.util.ThreadUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class DokitDbManager<T extends AbsMockApiBean> {
    public static final String IS_NOT_NORMAL_QUERY_PARAMS = "is not normal query parmas";
    public static final String IS_NOT_NORMAL_BODY_PARAMS = "is not normal body parmas";
    public static final String MEDIA_TYPE_FORM = "application/x-www-form-urlencoded";
    public static final String MEDIA_TYPE_JSON = "application/json";
    public static final String MEDIA_TYPE_PLAIN = "text/plain";
    private static final String TAG = "DokitDbManager";
    private Map<String, List<T>> mGlobalInterceptApiMaps = new HashMap<String, List<T>>();
    private Map<String, List<T>> mGlobalTemplateApiMaps = new HashMap<String, List<T>>();
    private MockTemplateApiBean mGlobalTemplateApiBean;
    public static final String CONTENT_TYPE = "application/json";
    public static final int MOCK_API_INTERCEPT = 1;
    public static final int MOCK_API_TEMPLATE = 2;
    public static int FROM_SDK_DIDI = 100;
    public static int FROM_SDK_OTHER = 101;

    public Map<String, List<T>> getGlobalInterceptApiMaps() {
        return this.mGlobalInterceptApiMaps;
    }

    public Map<String, List<T>> getGlobalTemplateApiMaps() {
        return this.mGlobalTemplateApiMaps;
    }

    public MockTemplateApiBean getGlobalTemplateApiBean() {
        return this.mGlobalTemplateApiBean;
    }

    public void setGlobalTemplateApiBean(MockTemplateApiBean mGlobalTemplateApiBean) {
        this.mGlobalTemplateApiBean = mGlobalTemplateApiBean;
    }

    public static DokitDbManager getInstance() {
        return Holder.INSTANCE;
    }

    public void getAllInterceptApis() {
        ThreadUtils.executeByIo((ThreadUtils.Task)new ThreadUtils.SimpleTask<List<T>>(){

            public List<T> doInBackground() throws Throwable {
                DokitDatabase db2 = DokitViewManager.getINSTANCE().getDb();
                if (db2.mockApiDao() != null) {
                    return db2.mockApiDao().getAllInterceptApi();
                }
                throw new NullPointerException("mDb == null || mDb.mockApiDao()");
            }

            public void onSuccess(List<T> result2) {
                DokitDbManager.this.list2mapByIntercept(result2);
            }

            public void onFail(Throwable t) {
                super.onFail(t);
                LogHelper.e(DokitDbManager.TAG, "error====>" + t.getMessage());
            }
        });
    }

    public void getAllTemplateApis() {
        ThreadUtils.executeByIo((ThreadUtils.Task)new ThreadUtils.SimpleTask<List<T>>(){

            public List<T> doInBackground() throws Throwable {
                DokitDatabase db2 = DokitViewManager.getINSTANCE().getDb();
                if (db2.mockApiDao() != null) {
                    return db2.mockApiDao().getAllTemplateApi();
                }
                throw new NullPointerException("mDb == null || mDb.mockApiDao()");
            }

            public void onSuccess(List<T> result2) {
                DokitDbManager.this.list2mapByTemplate(result2);
            }

            public void onFail(Throwable t) {
                super.onFail(t);
                LogHelper.e(DokitDbManager.TAG, "error====>" + t.getMessage());
            }
        });
    }

    public T getTemplateApiByIdInDb(String id2) {
        return (T)DokitViewManager.getINSTANCE().getDb().mockApiDao().findTemplateApiById(id2);
    }

    public T getInterceptApiByIdInDb(String id2) {
        return (T)DokitViewManager.getINSTANCE().getDb().mockApiDao().findInterceptApiById(id2);
    }

    public T getInterceptApiByIdInMap(String path, String id2, int fromSDK) {
        if (this.mGlobalInterceptApiMaps == null) {
            return null;
        }
        List<T> mGlobalInterceptApis = this.mGlobalInterceptApiMaps.get(path);
        if (mGlobalInterceptApis == null) {
            path = DoKitManager.dealDidiPlatformPath(path, fromSDK);
            mGlobalInterceptApis = this.mGlobalInterceptApiMaps.get(path);
        }
        if (mGlobalInterceptApis == null) {
            return null;
        }
        AbsMockApiBean selectedMockApi = null;
        for (AbsMockApiBean mockApi : mGlobalInterceptApis) {
            if (!mockApi.getId().equals(id2)) continue;
            selectedMockApi = mockApi;
            break;
        }
        return (T)selectedMockApi;
    }

    public T getTemplateApiByIdInMap(String path, String id2, int fromSDK) {
        if (this.mGlobalTemplateApiMaps == null) {
            return null;
        }
        List<T> mGlobalTemplateApis = this.mGlobalTemplateApiMaps.get(path);
        if (mGlobalTemplateApis == null) {
            path = DoKitManager.dealDidiPlatformPath(path, fromSDK);
            mGlobalTemplateApis = this.mGlobalTemplateApiMaps.get(path);
        }
        if (mGlobalTemplateApis == null) {
            return null;
        }
        AbsMockApiBean selectedMockApi = null;
        for (AbsMockApiBean mockApi : mGlobalTemplateApis) {
            if (!mockApi.getId().equals(id2)) continue;
            selectedMockApi = mockApi;
            break;
        }
        return (T)selectedMockApi;
    }

    public void insertAllInterceptApi(final List<MockInterceptApiBean> mockApis) {
        ThreadUtils.executeByIo((ThreadUtils.Task)new ThreadUtils.SimpleTask<Object>(){

            public Object doInBackground() throws Throwable {
                DokitViewManager.getINSTANCE().getDb().mockApiDao().insertAllInterceptApi(mockApis);
                DokitDbManager.this.getAllInterceptApis();
                return null;
            }

            public void onSuccess(Object result2) {
            }
        });
    }

    public void insertAllTemplateApi(final List<MockTemplateApiBean> mockApis) {
        ThreadUtils.executeByIo((ThreadUtils.Task)new ThreadUtils.SimpleTask<Void>(){

            public Void doInBackground() throws Throwable {
                DokitViewManager.getINSTANCE().getDb().mockApiDao().insertAllTemplateApi(mockApis);
                return null;
            }

            public void onSuccess(Void result2) {
                DokitDbManager.this.getAllTemplateApis();
            }
        });
    }

    public void updateInterceptApi(final MockInterceptApiBean mockApi) {
        ThreadUtils.executeByIo((ThreadUtils.Task)new ThreadUtils.SimpleTask<Void>(){

            public Void doInBackground() throws Throwable {
                DokitViewManager.getINSTANCE().getDb().mockApiDao().updateInterceptApi(mockApi);
                return null;
            }

            public void onSuccess(Void result2) {
                DokitDbManager.this.getAllInterceptApis();
            }
        });
    }

    public void updateTemplateApi(final MockTemplateApiBean mockApi) {
        ThreadUtils.executeByIo((ThreadUtils.Task)new ThreadUtils.SimpleTask<Object>(){

            public Object doInBackground() throws Throwable {
                DokitViewManager.getINSTANCE().getDb().mockApiDao().updateTemplateApi(mockApi);
                DokitDbManager.this.getAllTemplateApis();
                return null;
            }

            public void onSuccess(Object result2) {
            }
        });
    }

    public String getMockInterceptSelectedSceneIdByPathAndId(String path, String id2) {
        if (this.mGlobalInterceptApiMaps.get(path) == null) {
            return "";
        }
        String selectedSceneId = "";
        for (AbsMockApiBean mockApi : this.mGlobalInterceptApiMaps.get(path)) {
            if (!mockApi.getId().equals(id2)) continue;
            selectedSceneId = mockApi.getSelectedSceneId();
            break;
        }
        return selectedSceneId;
    }

    public String isMockMatched(String path, String jsonQuery, String jsonRequestBody, int operateType, int fromSDK) {
        if (!TextUtils.isEmpty((CharSequence)jsonQuery) && jsonQuery.equals(IS_NOT_NORMAL_QUERY_PARAMS)) {
            return "";
        }
        if (!TextUtils.isEmpty((CharSequence)jsonRequestBody) && jsonRequestBody.equals(IS_NOT_NORMAL_BODY_PARAMS)) {
            return "";
        }
        T mockApi = this.mockMatched(path, jsonQuery, jsonRequestBody, operateType, fromSDK);
        if (mockApi == null) {
            return "";
        }
        return ((AbsMockApiBean)mockApi).getId();
    }

    private T mockMatched(String path, String jsonQuery, String jsonRequestBody, int operateType, int fromSDK) {
        List<T> mockApis = null;
        if (operateType == 1) {
            mockApis = this.mGlobalInterceptApiMaps.get(path);
            if (mockApis == null) {
                path = DoKitManager.dealDidiPlatformPath(path, fromSDK);
                mockApis = this.mGlobalInterceptApiMaps.get(path);
            }
        } else if (operateType == 2 && (mockApis = this.mGlobalTemplateApiMaps.get(path)) == null) {
            path = DoKitManager.dealDidiPlatformPath(path, fromSDK);
            mockApis = this.mGlobalTemplateApiMaps.get(path);
        }
        if (mockApis == null) {
            return null;
        }
        AbsMockApiBean matchedMockApi = null;
        for (AbsMockApiBean mockApi : mockApis) {
            if (!mockApi.isOpen() || !this.queriesMatched(jsonQuery, mockApi) || !this.bodyMatched(jsonRequestBody, mockApi)) continue;
            matchedMockApi = mockApi;
            break;
        }
        return (T)matchedMockApi;
    }

    private boolean queriesMatched(String jsonQuery, T mockApi) {
        boolean mockQueryIsEmpty;
        String mockQuery = ((AbsMockApiBean)mockApi).getQuery();
        boolean bl = mockQueryIsEmpty = TextUtils.isEmpty((CharSequence)mockQuery) || "{}".equals(mockQuery);
        if (mockQueryIsEmpty && TextUtils.isEmpty((CharSequence)jsonQuery)) {
            return true;
        }
        if (!TextUtils.isEmpty((CharSequence)jsonQuery) && mockQueryIsEmpty) {
            return true;
        }
        if (TextUtils.isEmpty((CharSequence)jsonQuery) && !mockQueryIsEmpty) {
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)jsonQuery) && !mockQueryIsEmpty) {
            try {
                JSONObject jsonQueryLocal = new JSONObject(jsonQuery);
                JSONObject jsonQueryMock = new JSONObject(mockQuery);
                ArrayList keys = new ArrayList();
                Iterator iterator = jsonQueryMock.keys();
                while (iterator.hasNext()) {
                    keys.add(iterator.next());
                }
                int count = 0;
                for (int index = 0; index < keys.size(); ++index) {
                    String key = (String)keys.get(index);
                    if (!jsonQueryLocal.has(key) || !jsonQueryMock.getString(key).equals(jsonQueryLocal.get(key))) continue;
                    ++count;
                }
                if (count == keys.size()) {
                    return true;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private boolean bodyMatched(String jsonRequestBody, T mockApi) {
        boolean mockQueryIsEmpty;
        String mockBody = ((AbsMockApiBean)mockApi).getBody();
        boolean bl = mockQueryIsEmpty = TextUtils.isEmpty((CharSequence)mockBody) || "{}".equals(mockBody);
        if (mockQueryIsEmpty && TextUtils.isEmpty((CharSequence)jsonRequestBody)) {
            return true;
        }
        if (!TextUtils.isEmpty((CharSequence)jsonRequestBody) && mockQueryIsEmpty) {
            return true;
        }
        if (TextUtils.isEmpty((CharSequence)jsonRequestBody) && !mockQueryIsEmpty) {
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)jsonRequestBody) && !mockQueryIsEmpty) {
            try {
                JSONObject jsonBodyLocal = new JSONObject(jsonRequestBody);
                JSONObject jsonBodyMock = new JSONObject(mockBody);
                ArrayList keys = new ArrayList();
                Iterator iterator = jsonBodyMock.keys();
                while (iterator.hasNext()) {
                    keys.add(iterator.next());
                }
                int count = 0;
                for (int index = 0; index < keys.size(); ++index) {
                    String key = (String)keys.get(index);
                    if (!jsonBodyLocal.has(key) || !jsonBodyMock.getString(key).equals(jsonBodyLocal.get(key))) continue;
                    ++count;
                }
                if (count == keys.size()) {
                    return true;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private void list2mapByIntercept(List<T> interceptApiBeans) {
        this.mGlobalInterceptApiMaps.clear();
        for (AbsMockApiBean mockApi : interceptApiBeans) {
            if (this.mGlobalInterceptApiMaps.get(mockApi.getPath()) == null) {
                ArrayList<AbsMockApiBean> mockInterceptApiBeans = new ArrayList<AbsMockApiBean>();
                mockInterceptApiBeans.add(mockApi);
                this.mGlobalInterceptApiMaps.put(mockApi.getPath(), mockInterceptApiBeans);
                continue;
            }
            this.mGlobalInterceptApiMaps.get(mockApi.getPath()).add(mockApi);
        }
    }

    private void list2mapByTemplate(List<T> templateApiBeans) {
        this.mGlobalTemplateApiMaps.clear();
        for (AbsMockApiBean mockApi : templateApiBeans) {
            if (this.mGlobalTemplateApiMaps.get(mockApi.getPath()) == null) {
                ArrayList<AbsMockApiBean> mockTemplateApiBeans = new ArrayList<AbsMockApiBean>();
                mockTemplateApiBeans.add(mockApi);
                this.mGlobalTemplateApiMaps.put(mockApi.getPath(), mockTemplateApiBeans);
                continue;
            }
            this.mGlobalTemplateApiMaps.get(mockApi.getPath()).add(mockApi);
        }
    }

    private static class Holder {
        private static DokitDbManager INSTANCE = new DokitDbManager();

        private Holder() {
        }
    }
}

