/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.okhttp.interceptor;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.health.AppHealthInfoUtil;
import com.didichuxing.doraemonkit.kit.health.model.AppHealthInfo;
import com.didichuxing.doraemonkit.kit.network.okhttp.InterceptorUtil;
import com.didichuxing.doraemonkit.kit.network.okhttp.interceptor.AbsDoKitInterceptor;
import com.didichuxing.doraemonkit.kit.network.room_db.DokitDbManager;
import com.didichuxing.doraemonkit.kit.network.room_db.MockInterceptApiBean;
import com.didichuxing.doraemonkit.kit.network.room_db.MockTemplateApiBean;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import com.didichuxing.doraemonkit.util.DoKitCommUtil;
import com.didichuxing.doraemonkit.util.EncodeUtils;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.util.TimeUtils;
import com.didichuxing.doraemonkit.util.ToastUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONObject;

public class DokitMockInterceptor
extends AbsDoKitInterceptor {
    @NonNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request oldRequest = chain.request();
        Response oldResponse = chain.proceed(oldRequest);
        String contentType = oldResponse.header("Content-Type");
        if (InterceptorUtil.isImg(contentType)) {
            return oldResponse;
        }
        HttpUrl url = oldRequest.url();
        String host = url.host();
        if (host.equalsIgnoreCase("mock.dokit.cn")) {
            return oldResponse;
        }
        String path = URLDecoder.decode(url.encodedPath(), "utf-8");
        String queries = url.query();
        String jsonQuery = this.transformQuery(queries);
        String jsonRequestBody = this.transformRequestBody(oldRequest.body());
        String interceptMatchedId = DokitDbManager.getInstance().isMockMatched(path, jsonQuery, jsonRequestBody, 1, DokitDbManager.FROM_SDK_OTHER);
        String templateMatchedId = DokitDbManager.getInstance().isMockMatched(path, jsonQuery, jsonRequestBody, 2, DokitDbManager.FROM_SDK_OTHER);
        try {
            if (DoKitManager.APP_HEALTH_RUNNING) {
                this.addNetWokInfoInAppHealth(oldRequest, oldResponse);
            }
            if (!TextUtils.isEmpty((CharSequence)interceptMatchedId)) {
                return this.matchedInterceptRule(url, path, interceptMatchedId, templateMatchedId, oldRequest, oldResponse, chain);
            }
            this.matchedTemplateRule(oldResponse, path, templateMatchedId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return oldResponse;
    }

    private String transformQuery(String query) {
        String json = "";
        if (TextUtils.isEmpty((CharSequence)query)) {
            return json;
        }
        try {
            json = DoKitCommUtil.param2Json(EncodeUtils.urlDecode((String)query));
            new JSONObject(json);
        }
        catch (Exception e) {
            json = "is not normal query parmas";
        }
        return json;
    }

    private String transformRequestBody(RequestBody requestBody) {
        String json = "";
        if (requestBody == null || requestBody.contentType() == null) {
            return json;
        }
        try {
            String strBody = EncodeUtils.urlDecode((String)DoKitCommUtil.requestBodyToString(requestBody));
            if (TextUtils.isEmpty((CharSequence)strBody)) {
                return "";
            }
            if (requestBody.contentType().toString().toLowerCase().contains("application/x-www-form-urlencoded")) {
                String form = strBody;
                json = DoKitCommUtil.param2Json(form);
                new JSONObject(json);
            } else if (requestBody.contentType().toString().toLowerCase().contains("application/json")) {
                json = strBody;
                new JSONObject(json);
            } else if (requestBody.contentType().toString().toLowerCase().contains("text/plain")) {
                json = strBody;
                try {
                    new JSONObject(json);
                }
                catch (Exception e) {
                    json = DoKitCommUtil.param2Json(json);
                    if (json.equals("{}")) {
                        json = "is not normal body parmas";
                    }
                }
            } else {
                json = "is not normal body parmas";
            }
        }
        catch (Exception e) {
            json = "";
            LogHelper.e(this.getTAG(), "===body json====>" + json);
        }
        return json;
    }

    private void addNetWokInfoInAppHealth(@NonNull Request request2, @NonNull Response response) {
        try {
            if (ActivityUtils.getTopActivity() == null) {
                return;
            }
            long upSize = -1L;
            long downSize = -1L;
            if (request2.body() != null) {
                upSize = request2.body().contentLength();
            }
            if (response.body() != null) {
                ResponseBody peekBody = response.peekBody(Long.MAX_VALUE);
                downSize = peekBody.bytes().length;
            }
            if (upSize < 0L && downSize < 0L) {
                return;
            }
            upSize = upSize > 0L ? upSize : 0L;
            downSize = downSize > 0L ? downSize : 0L;
            String activityName = ActivityUtils.getTopActivity().getClass().getCanonicalName();
            AppHealthInfo.DataBean.NetworkBean networkBean = AppHealthInfoUtil.getInstance().getNetWorkInfo(activityName);
            AppHealthInfo.DataBean.NetworkBean.NetworkValuesBean networkValuesBean = new AppHealthInfo.DataBean.NetworkBean.NetworkValuesBean();
            networkValuesBean.setCode("" + response.code());
            networkValuesBean.setUp("" + upSize);
            networkValuesBean.setDown("" + downSize);
            networkValuesBean.setMethod(request2.method());
            networkValuesBean.setTime("" + TimeUtils.getNowMills());
            networkValuesBean.setUrl(request2.url().toString());
            if (networkBean == null) {
                networkBean = new AppHealthInfo.DataBean.NetworkBean();
                networkBean.setPage(activityName);
                ArrayList<AppHealthInfo.DataBean.NetworkBean.NetworkValuesBean> networkValuesBeans = new ArrayList<AppHealthInfo.DataBean.NetworkBean.NetworkValuesBean>();
                networkValuesBeans.add(networkValuesBean);
                networkBean.setValues(networkValuesBeans);
                AppHealthInfoUtil.getInstance().addNetWorkInfo(networkBean);
            } else {
                List<AppHealthInfo.DataBean.NetworkBean.NetworkValuesBean> networkValuesBeans = networkBean.getValues();
                if (networkValuesBeans == null) {
                    networkValuesBeans = new ArrayList<AppHealthInfo.DataBean.NetworkBean.NetworkValuesBean>();
                    networkValuesBeans.add(networkValuesBean);
                    networkBean.setValues(networkValuesBeans);
                } else {
                    networkValuesBeans.add(networkValuesBean);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Response matchedInterceptRule(HttpUrl url, String path, String interceptMatchedId, String templateMatchedId, Request oldRequest, Response oldResponse, Interceptor.Chain chain) throws Exception {
        String scheme = url.scheme();
        MockInterceptApiBean interceptApiBean = (MockInterceptApiBean)DokitDbManager.getInstance().getInterceptApiByIdInMap(path, interceptMatchedId, DokitDbManager.FROM_SDK_OTHER);
        if (interceptApiBean == null) {
            this.matchedTemplateRule(oldResponse, path, templateMatchedId);
            return oldResponse;
        }
        String selectedSceneId = interceptApiBean.getSelectedSceneId();
        if (!interceptApiBean.isOpen()) {
            this.matchedTemplateRule(oldResponse, path, templateMatchedId);
            return oldResponse;
        }
        if (TextUtils.isEmpty((CharSequence)selectedSceneId)) {
            this.matchedTemplateRule(oldResponse, path, templateMatchedId);
            return oldResponse;
        }
        StringBuilder sb = new StringBuilder();
        String newUrl = "http://".contains(scheme.toLowerCase()) ? sb.append("http://").append("mock.dokit.cn").append("/api/app/scene/").append(selectedSceneId).toString() : sb.append("https://").append("mock.dokit.cn").append("/api/app/scene/").append(selectedSceneId).toString();
        Request newRequest = new Request.Builder().method("GET", null).url(newUrl).build();
        oldResponse.close();
        Response newResponse = chain.proceed(newRequest);
        if (newResponse.code() == 200) {
            ToastUtils.showShort((CharSequence)("\u63a5\u53e3\u522b\u540d:==" + interceptApiBean.getMockApiName() + "==\u5df2\u88ab\u62e6\u622a"));
            if (this.newResponseHasData(newResponse)) {
                this.matchedTemplateRule(newResponse, path, templateMatchedId);
                return newResponse;
            }
            this.matchedTemplateRule(oldResponse, path, templateMatchedId);
            return oldResponse;
        }
        this.matchedTemplateRule(oldResponse, path, templateMatchedId);
        return oldResponse;
    }

    private void matchedTemplateRule(Response oldResponse, String path, String templateMatchedId) throws Exception {
        if (TextUtils.isEmpty((CharSequence)templateMatchedId)) {
            return;
        }
        MockTemplateApiBean templateApiBean = (MockTemplateApiBean)DokitDbManager.getInstance().getTemplateApiByIdInMap(path, templateMatchedId, DokitDbManager.FROM_SDK_OTHER);
        if (templateApiBean == null) {
            return;
        }
        if (templateApiBean.isOpen()) {
            this.saveResponse2DB(oldResponse, templateApiBean);
        }
    }

    private void saveResponse2DB(Response response, MockTemplateApiBean mockApi) throws Exception {
        if (response.code() != 200) {
            return;
        }
        if (response.body() == null) {
            return;
        }
        String host = response.request().url().host();
        ResponseBody responseBody = response.peekBody(Long.MAX_VALUE);
        String strResponseBody = responseBody.string();
        if (TextUtils.isEmpty((CharSequence)strResponseBody)) {
            return;
        }
        if (host.equals("mock.dokit.cn")) {
            mockApi.setResponseFrom(0);
        } else {
            mockApi.setResponseFrom(1);
        }
        mockApi.setStrResponse(strResponseBody);
        DokitDbManager.getInstance().updateTemplateApi(mockApi);
        ToastUtils.showShort((CharSequence)("\u6a21\u677f\u522b\u540d:==" + mockApi.getMockApiName() + "==\u5df2\u88ab\u4fdd\u5b58"));
    }

    private boolean newResponseHasData(Response response) throws Exception {
        return response.body() != null;
    }
}

