/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.core;

import com.didichuxing.doraemonkit.kit.network.stream.GunzippingOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.InflaterOutputStream;

public class RequestBodyHelper {
    private ByteArrayOutputStream mDeflatedOutput;
    private static final String GZIP_ENCODING = "gzip";
    private static final String DEFLATE_ENCODING = "deflate";

    public OutputStream createBodySink(String contentEncoding) throws IOException {
        ByteArrayOutputStream deflatedOutput = new ByteArrayOutputStream();
        OutputStream deflatingOutput = GZIP_ENCODING.equals(contentEncoding) ? GunzippingOutputStream.create(deflatedOutput) : (DEFLATE_ENCODING.equals(contentEncoding) ? new InflaterOutputStream(deflatedOutput) : deflatedOutput);
        this.mDeflatedOutput = deflatedOutput;
        return deflatingOutput;
    }

    public byte[] getDisplayBody() {
        this.throwIfNoBody();
        return this.mDeflatedOutput.toByteArray();
    }

    public boolean hasBody() {
        return this.mDeflatedOutput != null;
    }

    private void throwIfNoBody() {
        if (!this.hasBody()) {
            throw new IllegalStateException("No body found; has createBodySink been called?");
        }
    }
}

