/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network;

import android.os.Handler;
import android.os.Looper;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.network.OnNetworkInfoUpdateListener;
import com.didichuxing.doraemonkit.kit.network.bean.NetworkRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class NetworkManager {
    public static final String MOCK_SCHEME_HTTP = "http://";
    public static final String MOCK_SCHEME_HTTPS = "https://";
    private static final String MOCK_HOST_DEBUG = "mock.dokit.cn";
    private static final String MOCK_HOST_RELEASE = "mock.dokit.cn";
    private static final String MOCK_DEBUG_DOMAIN = "https://mock.dokit.cn";
    private static final String MOCK_RELEASE_DOMAIN = "https://mock.dokit.cn";
    public static final String MOCK_DOMAIN = "https://mock.dokit.cn";
    public static final String MOCK_HOST = "mock.dokit.cn";
    public static final String APP_HEALTH_URL = "https://www.dokit.cn/healthCheck/addCheckData";
    public static final String APP_DATA_PICK_URL = "https://www.dokit.cn/pointData/addPointData";
    public static final String APP_DOCUMENT_URL = "https://xingyun.xiaojukeji.com/docs/dokit/#/TimeProfiler";
    public static final String FILE_MANAGER_DOCUMENT_URL = "https://xingyun.xiaojukeji.com/docs/dokit/#/FileList";
    public static final String APP_START_DATA_PICK_URL = "https://doraemon.xiaojukeji.com/uploadAppData";
    public static final String DOKIT_MORE_PAGE_URL = "http://star.xiaojukeji.com/config/get.node?city=-1&areaid=&name=group";
    private static final int MAX_SIZE = 100;
    private long mStartTime;
    private OnNetworkInfoUpdateListener mOnNetworkInfoUpdateListener;
    private int mPostCount;
    private int mGetCount;
    private int mTotalCount;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private AtomicBoolean mIsActive = new AtomicBoolean(false);
    private List<NetworkRecord> mRecords = Collections.synchronizedList(new ArrayList());

    public NetworkRecord getRecord(int requestId) {
        for (NetworkRecord record : this.mRecords) {
            if (record.mRequestId != requestId) continue;
            return record;
        }
        return null;
    }

    public static NetworkManager get() {
        return Holder.INSTANCE;
    }

    public void addRecord(int requestId, NetworkRecord record) {
        if (this.mRecords.size() > 100) {
            this.mRecords.remove(0);
        }
        if (record.isPostRecord()) {
            ++this.mPostCount;
        } else if (record.isGetRecord()) {
            ++this.mGetCount;
        }
        ++this.mTotalCount;
        this.mRecords.add(record);
        this.updateRecord(record, true);
    }

    public void updateRecord(final NetworkRecord record, final boolean add) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (DoKitManager.INSTANCE.getCALLBACK() != null && add) {
                    DoKitManager.INSTANCE.getCALLBACK().onNetworkCallBack(record);
                }
                if (NetworkManager.this.mOnNetworkInfoUpdateListener != null) {
                    NetworkManager.this.mOnNetworkInfoUpdateListener.onNetworkInfoUpdate(record, add);
                }
            }
        });
    }

    public void startMonitor() {
        if (this.mIsActive.get()) {
            return;
        }
        this.mIsActive.set(true);
        this.mStartTime = System.currentTimeMillis();
    }

    public void stopMonitor() {
        if (!this.mIsActive.get()) {
            return;
        }
        this.mIsActive.set(false);
        this.mStartTime = 0L;
    }

    public static boolean isActive() {
        return NetworkManager.get().mIsActive.get();
    }

    public List<NetworkRecord> getRecords() {
        return this.mRecords;
    }

    public void setOnNetworkInfoUpdateListener(OnNetworkInfoUpdateListener onNetworkInfoUpdateListener) {
        this.mOnNetworkInfoUpdateListener = onNetworkInfoUpdateListener;
    }

    public long getRunningTime() {
        if (this.mStartTime == 0L) {
            return this.mStartTime;
        }
        long time = System.currentTimeMillis() - this.mStartTime;
        return time;
    }

    public long getTotalRequestSize() {
        long totalSize = 0L;
        for (NetworkRecord record : this.mRecords) {
            totalSize += record.requestLength;
        }
        return totalSize;
    }

    public long getTotalSize() {
        long totalSize = 0L;
        for (NetworkRecord record : this.mRecords) {
            totalSize += record.requestLength;
            totalSize += record.responseLength;
        }
        return totalSize;
    }

    public long getTotalResponseSize() {
        long totalSize = 0L;
        for (NetworkRecord record : this.mRecords) {
            totalSize += record.responseLength;
        }
        return totalSize;
    }

    public int getPostCount() {
        return this.mPostCount;
    }

    public int getGetCount() {
        return this.mGetCount;
    }

    public int getTotalCount() {
        return this.mTotalCount;
    }

    private static class Holder {
        private static NetworkManager INSTANCE = new NetworkManager();

        private Holder() {
        }
    }
}

