/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.loginfo.reader;

import android.text.TextUtils;
import com.didichuxing.doraemonkit.kit.loginfo.helper.LogcatHelper;
import com.didichuxing.doraemonkit.kit.loginfo.helper.RuntimeHelper;
import com.didichuxing.doraemonkit.kit.loginfo.reader.AbsLogcatReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;

public class SingleLogcatReader
extends AbsLogcatReader {
    private static final String TAG = "SingleLogcatReader";
    private Process logcatProcess;
    private BufferedReader bufferedReader;
    private String logBuffer;
    private String lastLine;

    public SingleLogcatReader(boolean recordingMode, String logBuffer, String lastLine) throws IOException {
        super(recordingMode);
        this.logBuffer = logBuffer;
        this.lastLine = lastLine;
        this.init();
    }

    private void init() throws IOException {
        this.logcatProcess = LogcatHelper.getLogcatProcess(this.logBuffer);
        this.bufferedReader = new BufferedReader(new InputStreamReader(this.logcatProcess.getInputStream()), 8192);
    }

    public String getLogBuffer() {
        return this.logBuffer;
    }

    @Override
    public void killQuietly() {
        if (this.logcatProcess != null) {
            RuntimeHelper.destroy(this.logcatProcess);
        }
    }

    @Override
    public String readLine() throws IOException {
        String line = this.bufferedReader.readLine();
        if (this.recordingMode && this.lastLine != null && this.lastLine.equals(line)) {
            this.lastLine = null;
        }
        return line;
    }

    private boolean isAfterLastTime(String line) {
        return this.isDatedLogLine(this.lastLine) && this.isDatedLogLine(line) && line.compareTo(this.lastLine) > 0;
    }

    private boolean isDatedLogLine(String line) {
        return !TextUtils.isEmpty((CharSequence)line) && line.length() >= 18 && Character.isDigit(line.charAt(0));
    }

    @Override
    public boolean readyToRecord() {
        return this.recordingMode && this.lastLine == null;
    }

    @Override
    public List<Process> getProcesses() {
        return Collections.singletonList(this.logcatProcess);
    }
}

