/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.loginfo;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.DoKitEnv;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.DokitViewLayoutParams;
import com.didichuxing.doraemonkit.kit.core.UniversalActivity;
import com.didichuxing.doraemonkit.kit.loginfo.LogExportDialog;
import com.didichuxing.doraemonkit.kit.loginfo.LogInfoManager;
import com.didichuxing.doraemonkit.kit.loginfo.LogItemAdapter;
import com.didichuxing.doraemonkit.kit.loginfo.LogLine;
import com.didichuxing.doraemonkit.util.AppUtils;
import com.didichuxing.doraemonkit.util.DoKitFileUtil;
import com.didichuxing.doraemonkit.util.FileIOUtils;
import com.didichuxing.doraemonkit.util.FileUtils;
import com.didichuxing.doraemonkit.util.PathUtils;
import com.didichuxing.doraemonkit.util.ThreadUtils;
import com.didichuxing.doraemonkit.util.TimeUtils;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.dialog.DialogProvider;
import com.didichuxing.doraemonkit.widget.dialog.UniversalDialogFragment;
import com.didichuxing.doraemonkit.widget.titlebar.LogTitleBar;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class LogInfoDokitView
extends AbsDokitView
implements LogInfoManager.OnLogCatchListener {
    private static final String TAG = "LogInfoFloatPage";
    private static final int MAX_LOG_LINE_NUM = 10000;
    private RecyclerView mLogRv;
    private LogItemAdapter mLogItemAdapter;
    private EditText mLogFilter;
    private RadioGroup mRadioGroup;
    private TextView mLogHint;
    private RelativeLayout mLogRvWrap;
    private boolean mIsLoaded;
    private int counter = 0;
    private static final int UPDATE_CHECK_INTERVAL = 200;
    private boolean mAutoScrollToBottom = true;
    private boolean isMaximize = true;

    @Override
    public void onCreate(Context context) {
        LogInfoManager.getInstance().registerListener(this);
    }

    @Override
    public View onCreateView(Context context, FrameLayout view) {
        return LayoutInflater.from((Context)context).inflate(R.layout.dk_float_log_info, null);
    }

    @Override
    public void onViewCreated(FrameLayout view) {
        this.initView();
    }

    public void initView() {
        this.mLogHint = (TextView)this.findViewById(R.id.log_hint);
        this.mLogRvWrap = (RelativeLayout)this.findViewById(R.id.log_page);
        this.mLogRv = (RecyclerView)this.findViewById(R.id.log_list);
        this.mLogRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mLogItemAdapter = new LogItemAdapter(this.getContext());
        this.mLogRv.setAdapter((RecyclerView.Adapter)this.mLogItemAdapter);
        this.mLogFilter = (EditText)this.findViewById(R.id.log_filter);
        this.mLogFilter.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                LogInfoDokitView.this.mLogItemAdapter.getFilter().filter((CharSequence)s);
            }
        });
        LogTitleBar mTitleBar = (LogTitleBar)((Object)this.findViewById(R.id.dokit_title_bar));
        mTitleBar.setListener(new LogTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                LogInfoManager.getInstance().stop();
                LogInfoManager.getInstance().removeListener();
                LogInfoDokitView.this.detach();
            }

            @Override
            public void onLeftClick() {
                LogInfoDokitView.this.minimize();
            }
        });
        this.mLogHint.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LogInfoDokitView.this.maximize();
            }
        });
        this.mRadioGroup = (RadioGroup)this.findViewById(R.id.radio_group);
        this.mRadioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                if (checkedId == R.id.verbose) {
                    LogInfoDokitView.this.mLogItemAdapter.setLogLevelLimit(2);
                } else if (checkedId == R.id.debug) {
                    LogInfoDokitView.this.mLogItemAdapter.setLogLevelLimit(3);
                } else if (checkedId == R.id.info) {
                    LogInfoDokitView.this.mLogItemAdapter.setLogLevelLimit(4);
                } else if (checkedId == R.id.warn) {
                    LogInfoDokitView.this.mLogItemAdapter.setLogLevelLimit(5);
                } else if (checkedId == R.id.error) {
                    LogInfoDokitView.this.mLogItemAdapter.setLogLevelLimit(6);
                }
                LogInfoDokitView.this.mLogItemAdapter.getFilter().filter((CharSequence)LogInfoDokitView.this.mLogFilter.getText());
            }
        });
        this.mLogRv.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
                LogInfoDokitView.this.mAutoScrollToBottom = layoutManager.findLastCompletelyVisibleItemPosition() == recyclerView.getAdapter().getItemCount() - 1;
            }
        });
        this.mRadioGroup.check(R.id.verbose);
        Button mBtnTop = (Button)this.findViewById(R.id.btn_top);
        Button mBtnBottom = (Button)this.findViewById(R.id.btn_bottom);
        Button mBtnClean = (Button)this.findViewById(R.id.btn_clean);
        Button mBtnExport = (Button)this.findViewById(R.id.btn_export);
        mBtnTop.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LogInfoDokitView.this.mLogItemAdapter == null || LogInfoDokitView.this.mLogItemAdapter.getItemCount() == 0) {
                    return;
                }
                LogInfoDokitView.this.mLogRv.scrollToPosition(0);
            }
        });
        mBtnBottom.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LogInfoDokitView.this.mLogItemAdapter == null || LogInfoDokitView.this.mLogItemAdapter.getItemCount() == 0) {
                    return;
                }
                LogInfoDokitView.this.mLogRv.scrollToPosition(LogInfoDokitView.this.mLogItemAdapter.getItemCount() - 1);
            }
        });
        mBtnExport.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LogInfoDokitView.this.mLogItemAdapter == null || LogInfoDokitView.this.mLogItemAdapter.getItemCount() == 0) {
                    ToastUtils.showShort((CharSequence)"\u6682\u65e0\u65e5\u5fd7\u4fe1\u606f\u53ef\u4ee5\u5bfc\u51fa");
                    return;
                }
                LogExportDialog logExportDialog = new LogExportDialog(new Object(), null);
                logExportDialog.setOnButtonClickListener(new LogExportDialog.OnButtonClickListener(){

                    @Override
                    public void onSaveClick(LogExportDialog dialog) {
                        LogInfoDokitView.this.export2File(100);
                        dialog.dismiss();
                    }

                    @Override
                    public void onShareClick(LogExportDialog dialog) {
                        LogInfoDokitView.this.export2File(101);
                        dialog.dismiss();
                    }
                });
                LogInfoDokitView.this.showDialog(logExportDialog);
            }
        });
        mBtnClean.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LogInfoDokitView.this.mLogItemAdapter == null || LogInfoDokitView.this.mLogItemAdapter.getItemCount() == 0) {
                    return;
                }
                LogInfoDokitView.this.counter = 0;
                LogInfoDokitView.this.mLogItemAdapter.clearLog();
            }
        });
    }

    private void showDialog(DialogProvider provider) {
        if (this.getActivity() == null || !(this.getActivity() instanceof FragmentActivity)) {
            return;
        }
        UniversalDialogFragment dialog = new UniversalDialogFragment();
        provider.setHost(dialog);
        dialog.setProvider(provider);
        provider.show(((FragmentActivity)this.getActivity()).getSupportFragmentManager());
    }

    private void export2File(final int operateType) {
        ToastUtils.showShort((CharSequence)"\u65e5\u5fd7\u4fdd\u5b58\u4e2d,\u8bf7\u7a0d\u540e...");
        final String logPath = PathUtils.getInternalAppFilesPath() + File.separator + AppUtils.getAppName() + "_" + TimeUtils.getNowString((DateFormat)new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss")) + ".log";
        final File logFile = new File(logPath);
        ThreadUtils.executeByCpu((ThreadUtils.Task)new ThreadUtils.Task<Boolean>(){

            public Boolean doInBackground() throws Throwable {
                try {
                    ArrayList<LogLine> logLines = new ArrayList<LogLine>(LogInfoDokitView.this.mLogItemAdapter.getTrueValues());
                    for (LogLine logLine : logLines) {
                        String strLog = logLine.getProcessId() + "      " + logLine.getTimestamp() + "   " + logLine.getTag() + "   " + logLine.getLogLevelText() + "   " + logLine.getLogOutput() + "\n";
                        FileIOUtils.writeFileFromString((File)logFile, (String)strLog, (boolean)true);
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            public void onSuccess(Boolean result2) {
                if (result2.booleanValue()) {
                    ToastUtils.showShort((CharSequence)("\u6587\u4ef6\u4fdd\u5b58\u5728:" + logPath));
                    if (operateType == 101) {
                        DoKitFileUtil.systemShare((Context)DoKitEnv.requireApp(), logFile);
                    }
                }
            }

            public void onCancel() {
                if (logFile.exists()) {
                    FileUtils.delete((File)logFile);
                }
                ToastUtils.showShort((CharSequence)"\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25");
            }

            public void onFail(Throwable t) {
                if (logFile.exists()) {
                    FileUtils.delete((File)logFile);
                }
                ToastUtils.showShort((CharSequence)"\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25");
            }
        });
    }

    @Override
    public void initDokitViewLayoutParams(DokitViewLayoutParams params) {
        params.flags = 32;
        params.width = DokitViewLayoutParams.MATCH_PARENT;
        params.height = DokitViewLayoutParams.MATCH_PARENT;
    }

    @Override
    public void onLogCatch(List<LogLine> logLines) {
        if (this.mLogRv == null || this.mLogItemAdapter == null) {
            return;
        }
        if (!this.mIsLoaded) {
            this.mIsLoaded = true;
            this.findViewById(R.id.ll_loading).setVisibility(8);
            this.mLogRv.setVisibility(0);
        }
        if (logLines.size() == 1) {
            this.mLogItemAdapter.addWithFilter(logLines.get(0), (CharSequence)this.mLogFilter.getText(), true);
        } else {
            for (LogLine line : logLines) {
                this.mLogItemAdapter.addWithFilter(line, (CharSequence)this.mLogFilter.getText(), false);
            }
            this.mLogItemAdapter.notifyDataSetChanged();
        }
        if (logLines.size() > 0) {
            LogLine line = logLines.get(logLines.size() - 1);
            this.mLogHint.setText((CharSequence)(line.getTag() + ":" + line.getLogOutput()));
        }
        if (++this.counter % 200 == 0 && this.mLogItemAdapter.getTrueValues().size() > 10000) {
            int numItemsToRemove = this.mLogItemAdapter.getTrueValues().size() - 10000;
            this.mLogItemAdapter.removeFirst(numItemsToRemove);
        }
        if (this.mAutoScrollToBottom) {
            this.scrollToBottom();
        }
    }

    private void scrollToBottom() {
        this.mLogRv.scrollToPosition(this.mLogItemAdapter.getItemCount() - 1);
    }

    private int getSelectLogLevel() {
        int checkedId = this.mRadioGroup.getCheckedRadioButtonId();
        if (checkedId == R.id.verbose) {
            return 2;
        }
        if (checkedId == R.id.debug) {
            return 3;
        }
        if (checkedId == R.id.info) {
            return 4;
        }
        if (checkedId == R.id.warn) {
            return 5;
        }
        if (checkedId == R.id.error) {
            return 6;
        }
        return 2;
    }

    public void minimize() {
        this.isMaximize = false;
        if (this.isNormalMode()) {
            this.mLogHint.setVisibility(0);
            this.mLogRvWrap.setVisibility(8);
            FrameLayout.LayoutParams layoutParams = this.getNormalLayoutParams();
            if (layoutParams == null) {
                return;
            }
            layoutParams.width = -1;
            layoutParams.height = -2;
            layoutParams.gravity = 0x800033;
            this.getDoKitView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else {
            this.mLogHint.setVisibility(0);
            this.mLogRvWrap.setVisibility(8);
            WindowManager.LayoutParams layoutParams = this.getSystemLayoutParams();
            if (layoutParams == null) {
                return;
            }
            layoutParams.flags = 8;
            layoutParams.width = -1;
            layoutParams.height = -2;
            layoutParams.gravity = 0x800033;
            this.mWindowManager.updateViewLayout(this.getDoKitView(), (ViewGroup.LayoutParams)layoutParams);
        }
    }

    private void maximize() {
        this.isMaximize = true;
        if (this.isNormalMode()) {
            this.mLogHint.setVisibility(8);
            this.mLogRvWrap.setVisibility(0);
            FrameLayout.LayoutParams layoutParams = this.getNormalLayoutParams();
            if (layoutParams == null) {
                return;
            }
            layoutParams.width = -1;
            layoutParams.height = -1;
            layoutParams.gravity = 0x800033;
            this.getDoKitView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else {
            this.mLogHint.setVisibility(8);
            this.mLogRvWrap.setVisibility(0);
            WindowManager.LayoutParams layoutParams = this.getSystemLayoutParams();
            if (layoutParams == null) {
                return;
            }
            layoutParams.flags = 32;
            layoutParams.width = -1;
            layoutParams.height = -1;
            layoutParams.gravity = 0x800033;
            this.mWindowManager.updateViewLayout(this.getDoKitView(), (ViewGroup.LayoutParams)layoutParams);
        }
    }

    @Override
    public boolean onBackPressed() {
        if (this.isMaximize) {
            this.minimize();
            return true;
        }
        return false;
    }

    @Override
    public void onResume() {
        super.onResume();
        if (!this.getActivity().getClass().getCanonicalName().equals(UniversalActivity.class.getCanonicalName())) {
            this.minimize();
        }
        LogInfoManager.getInstance().registerListener(this);
    }

    @Override
    public boolean shouldDealBackKey() {
        return true;
    }

    @Override
    public boolean canDrag() {
        return false;
    }
}

