/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.largepicture;

import com.didichuxing.doraemonkit.config.PerformanceSpInfoConfig;
import com.didichuxing.doraemonkit.kit.core.UniversalActivity;
import com.didichuxing.doraemonkit.kit.largepicture.LargeImageInfo;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class LargePictureManager {
    public static float MEMORY_DEFAULT_THRESHOLD = 1.0f;
    public static float FILE_DEFAULT_THRESHOLD = 150.0f;
    private double fileThreshold = PerformanceSpInfoConfig.getLargeImgFileThreshold(FILE_DEFAULT_THRESHOLD);
    private double memoryThreshold = PerformanceSpInfoConfig.getLargeImgMemoryThreshold(MEMORY_DEFAULT_THRESHOLD);
    private static final String TAG = "LargePictureManager";
    private DecimalFormat mDecimalFormat = new DecimalFormat("0.00");
    public static Map<String, LargeImageInfo> LARGE_IMAGE_INFO_MAP = new HashMap<String, LargeImageInfo>();

    public void setFileThreshold(double fileThreshold) {
        this.fileThreshold = fileThreshold;
    }

    public void setMemoryThreshold(double memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public static LargePictureManager getInstance() {
        return Holder.INSTANCE;
    }

    public void process(String url, int size) {
        if (ActivityUtils.getTopActivity() instanceof UniversalActivity) {
            return;
        }
        if (PerformanceSpInfoConfig.isLargeImgOpen()) {
            double fileSize = (double)size / 1024.0;
            this.saveImageInfo(url, fileSize);
        }
    }

    private void saveImageInfo(String url, double fileSize) {
        LargeImageInfo largeImageInfo;
        if (ActivityUtils.getTopActivity() instanceof UniversalActivity) {
            return;
        }
        if (LARGE_IMAGE_INFO_MAP.containsKey(url)) {
            largeImageInfo = LARGE_IMAGE_INFO_MAP.get(url);
        } else {
            largeImageInfo = new LargeImageInfo();
            LARGE_IMAGE_INFO_MAP.put(url, largeImageInfo);
            largeImageInfo.setUrl(url);
        }
        largeImageInfo.setFileSize(fileSize);
    }

    public void saveImageInfo(String url, double memorySize, int width, int height, String framework) {
        LargeImageInfo largeImageInfo;
        if (ActivityUtils.getTopActivity() instanceof UniversalActivity) {
            return;
        }
        if (LARGE_IMAGE_INFO_MAP.containsKey(url)) {
            largeImageInfo = LARGE_IMAGE_INFO_MAP.get(url);
        } else {
            largeImageInfo = new LargeImageInfo();
            LARGE_IMAGE_INFO_MAP.put(url, largeImageInfo);
            largeImageInfo.setUrl(url);
        }
        largeImageInfo.setMemorySize(memorySize);
        largeImageInfo.setWidth(width);
        largeImageInfo.setHeight(height);
        largeImageInfo.setFramework(framework);
    }

    private static class Holder {
        private static LargePictureManager INSTANCE = new LargePictureManager();

        private Holder() {
        }
    }
}

