/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.gpsmock;

import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.config.GpsMockConfig;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.core.SettingItem;
import com.didichuxing.doraemonkit.kit.core.SettingItemAdapter;
import com.didichuxing.doraemonkit.kit.gpsmock.GpsMockManager;
import com.didichuxing.doraemonkit.model.LatLng;
import com.didichuxing.doraemonkit.util.DoKitWebUtil;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.recyclerview.DividerItemDecoration;
import com.didichuxing.doraemonkit.widget.titlebar.HomeTitleBar;
import com.didichuxing.doraemonkit.widget.webview.MyWebView;
import com.didichuxing.doraemonkit.widget.webview.MyWebViewClient;
import java.util.ArrayList;

public class GpsMockFragment
extends BaseFragment
implements SettingItemAdapter.OnSettingItemSwitchListener,
MyWebViewClient.InvokeListener {
    private static final String TAG = "GpsMockFragment";
    private HomeTitleBar mTitleBar;
    private RecyclerView mSettingList;
    private SettingItemAdapter mSettingItemAdapter;
    private ImageView mIvSearch;
    private EditText mEdLongLat;
    private MyWebView mWebView;
    private boolean isInit = true;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.intiSettingList();
        this.initTitleBar();
        this.initMockLocationArea();
        this.initWebView();
    }

    private void initWebView() {
        this.mWebView = (MyWebView)((Object)this.findViewById(R.id.webview));
        DoKitWebUtil.webViewLoadLocalHtml(this.mWebView, "map/map.html");
        this.mWebView.addInvokeListener(this);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mWebView.removeInvokeListener(this);
    }

    private void initMockLocationArea() {
        this.mEdLongLat = (EditText)this.findViewById(R.id.ed_long_lat);
        this.mIvSearch = (ImageView)this.findViewById(R.id.iv_search);
        this.mIvSearch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GpsMockFragment.this.performMock();
            }
        });
    }

    private void performMock() {
        double latitude;
        double longitude;
        if (!this.checkInput()) {
            return;
        }
        String strLongLat = this.mEdLongLat.getText().toString();
        String[] longAndLat = strLongLat.split(" ");
        try {
            longitude = Double.parseDouble(longAndLat[0]);
            latitude = Double.parseDouble(longAndLat[1]);
        }
        catch (Exception e) {
            ToastUtils.showShort((CharSequence)"\u7ecf\u7eac\u5ea6\u5fc5\u987b\u4e3a\u6570\u5b57");
            return;
        }
        GpsMockManager.getInstance().mockLocationWithNotify(latitude, longitude);
        GpsMockConfig.saveMockLocation(new LatLng(latitude, longitude));
        String url = String.format("javascript:updateLocation(%s,%s)", latitude, longitude);
        this.mWebView.loadUrl(url);
        ToastUtils.showShort((CharSequence)this.getString(R.string.dk_gps_location_change_toast, new Object[]{"" + longitude, "" + latitude}));
    }

    private boolean checkInput() {
        double latitude;
        double longitude;
        String strLongLat = this.mEdLongLat.getText().toString();
        if (TextUtils.isEmpty((CharSequence)strLongLat)) {
            ToastUtils.showShort((CharSequence)"\u8bf7\u8f93\u5165\u7ecf\u7eac\u5ea6");
            return false;
        }
        String[] longAndLat = strLongLat.split(" ");
        if (longAndLat.length != 2) {
            ToastUtils.showShort((CharSequence)"\u8bf7\u8f93\u5165\u7b26\u5408\u89c4\u8303\u7684\u7ecf\u7eac\u5ea6\u683c\u5f0f");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)longAndLat[0])) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)longAndLat[1])) {
            return false;
        }
        try {
            longitude = Double.parseDouble(longAndLat[0]);
            latitude = Double.parseDouble(longAndLat[1]);
        }
        catch (Exception e) {
            ToastUtils.showShort((CharSequence)"\u7ecf\u7eac\u5ea6\u5fc5\u987b\u4e3a\u6570\u5b57");
            return false;
        }
        if (longitude > 180.0 || longitude < -180.0) {
            return false;
        }
        return !(latitude > 90.0) && !(latitude < -90.0);
    }

    private void initTitleBar() {
        this.mTitleBar = (HomeTitleBar)((Object)this.findViewById(R.id.title_bar));
        this.mTitleBar.setListener(new HomeTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                GpsMockFragment.this.finish();
            }
        });
    }

    private void intiSettingList() {
        this.mSettingList = (RecyclerView)this.findViewById(R.id.setting_list);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mSettingList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        ArrayList<SettingItem> settingItems = new ArrayList<SettingItem>();
        settingItems.add(new SettingItem(R.string.dk_gpsmock_open, GpsMockConfig.isGPSMockOpen()));
        this.mSettingItemAdapter = new SettingItemAdapter(this.getContext());
        this.mSettingItemAdapter.setData(settingItems);
        this.mSettingItemAdapter.setOnSettingItemSwitchListener(this);
        this.mSettingList.setAdapter((RecyclerView.Adapter)this.mSettingItemAdapter);
        DividerItemDecoration decoration = new DividerItemDecoration(1);
        decoration.setDrawable(this.getResources().getDrawable(R.drawable.dk_divider));
        this.mSettingList.addItemDecoration((RecyclerView.ItemDecoration)decoration);
    }

    @Override
    public void onSettingItemSwitch(View view, SettingItem data, boolean on) {
        if (data.desc == R.string.dk_gpsmock_open) {
            if (on) {
                this.performMock();
                GpsMockManager.getInstance().startMock();
            } else {
                GpsMockManager.getInstance().stopMock();
            }
            GpsMockConfig.setGPSMockOpen(on);
        }
    }

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_gps_mock;
    }

    @Override
    public void onNativeInvoke(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        Uri uri = Uri.parse((String)url);
        String lastPath = uri.getLastPathSegment();
        if (!"sendLocation".equals(lastPath)) {
            return;
        }
        String lat = uri.getQueryParameter("lat");
        String lnt = uri.getQueryParameter("lng");
        if (TextUtils.isEmpty((CharSequence)lat) && TextUtils.isEmpty((CharSequence)lnt)) {
            return;
        }
        this.mEdLongLat.setText((CharSequence)String.format("%s %s", lnt, lat));
        if (!this.isInit) {
            double latitude;
            double longitude;
            try {
                longitude = Double.valueOf(lnt);
                latitude = Double.valueOf(lat);
            }
            catch (Exception e) {
                ToastUtils.showShort((CharSequence)"\u7ecf\u7eac\u5ea6\u5fc5\u987b\u4e3a\u6570\u5b57");
                return;
            }
            GpsMockManager.getInstance().mockLocationWithNotify(latitude, longitude);
            GpsMockConfig.saveMockLocation(new LatLng(latitude, longitude));
            ToastUtils.showShort((CharSequence)this.getString(R.string.dk_gps_location_change_toast, new Object[]{"" + longitude, "" + latitude}));
        }
        this.isInit = false;
    }
}

