/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.fileexplorer;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.fileexplorer.SpAdapter;
import com.didichuxing.doraemonkit.kit.fileexplorer.SpBean;
import com.didichuxing.doraemonkit.util.DoKitSPUtil;
import com.didichuxing.doraemonkit.widget.titlebar.TitleBar;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SpFragment
extends BaseFragment {
    private SharedPreferences.Editor edit;
    private String spTableName;

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_sp_show;
    }

    private List<SpBean> getSpBeans() {
        ArrayList<SpBean> spBeans = new ArrayList<SpBean>();
        File mFile = (File)this.getArguments().getSerializable("file_key");
        if (mFile == null) {
            return spBeans;
        }
        this.spTableName = mFile.getName().replace(".xml", "");
        SharedPreferences sp = DoKitSPUtil.getSharedPrefs(this.spTableName);
        this.edit = sp.edit();
        Map all = sp.getAll();
        if (all.isEmpty()) {
            return spBeans;
        }
        for (Map.Entry entry : all.entrySet()) {
            spBeans.add(new SpBean((String)entry.getKey(), entry.getValue()));
        }
        return spBeans;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        List<SpBean> spBeans = this.getSpBeans();
        if (spBeans.isEmpty()) {
            this.finish();
            return;
        }
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.rv_sp);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity(), 1, false));
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this.getActivity(), 1));
        SpAdapter spAdapter = new SpAdapter((Context)this.getActivity());
        spAdapter.setOnSpDataChangerListener(new SpAdapter.OnSpDataChangerListener(){

            @Override
            public void onDataChanged(SpBean bean) {
                SpFragment.this.spUpData(bean);
            }
        });
        spAdapter.append(spBeans);
        recyclerView.setAdapter((RecyclerView.Adapter)spAdapter);
        if (this.spTableName != null) {
            TitleBar mTitleBar = (TitleBar)((Object)this.findViewById(R.id.title_bar));
            mTitleBar.setTitle(this.spTableName);
            mTitleBar.setOnTitleBarClickListener(new TitleBar.OnTitleBarClickListener(){

                @Override
                public void onLeftClick() {
                    SpFragment.this.finish();
                }

                @Override
                public void onRightClick() {
                }
            });
        }
    }

    public void spUpData(SpBean bean) {
        String key = bean.key;
        switch (bean.value.getClass().getSimpleName()) {
            case "String": {
                DoKitSPUtil.putString(key, bean.value.toString());
                break;
            }
            case "Boolean": {
                DoKitSPUtil.putBoolean(this.spTableName, key, (Boolean)bean.value);
                break;
            }
            case "Integer": {
                DoKitSPUtil.putInt(this.spTableName, key, (Integer)bean.value);
                break;
            }
            case "Float": {
                DoKitSPUtil.putFloat(this.spTableName, key, (Float)bean.value);
                break;
            }
            case "Long": {
                DoKitSPUtil.putLong(this.spTableName, key, (Long)bean.value);
                break;
            }
        }
    }
}

