/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.crash;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.View;
import androidx.core.view.ViewCompat;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.datapick.DataPickManager;
import com.didichuxing.doraemonkit.util.DoKitCacheUtils;
import com.didichuxing.doraemonkit.util.DoKitFileUtil;
import com.didichuxing.doraemonkit.util.DoKitImageUtil;
import com.didichuxing.doraemonkit.util.ToastUtils;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;

public class CrashCaptureManager
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = "CrashCaptureManager";
    private final Thread.UncaughtExceptionHandler mDefaultHandler;
    private final Handler mHandler;
    private Context mContext;
    private SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmdd");
    private String mFilenamePrefix;

    private CrashCaptureManager() {
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
        this.generateFilenamePrefix();
    }

    public static CrashCaptureManager getInstance() {
        return Holder.INSTANCE;
    }

    public void init(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public void start() {
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public void stop() {
        Thread.setDefaultUncaughtExceptionHandler(this.mDefaultHandler);
    }

    @Override
    public void uncaughtException(final Thread t, final Throwable e) {
        this.generateFilenamePrefix();
        this.asyncSaveCrashScreenshot();
        DoKitCacheUtils.saveObject((Serializable)((Object)Log.getStackTraceString((Throwable)e)), this.getCrashCacheFile());
        DataPickManager.getInstance().saveData2Local();
        this.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.showShort((CharSequence)CrashCaptureManager.this.mContext.getString(R.string.dk_crash_capture_tips));
            }
        });
        this.postDelay(new Runnable(){

            @Override
            public void run() {
                if (CrashCaptureManager.this.mDefaultHandler != null) {
                    CrashCaptureManager.this.mDefaultHandler.uncaughtException(t, e);
                }
            }
        }, 2000L);
    }

    private void post(Runnable r) {
        this.mHandler.post(r);
    }

    private void postDelay(Runnable r, long delayMillis) {
        this.mHandler.postDelayed(r, delayMillis);
    }

    public File getCrashCacheDir() {
        File dir = new File(this.mContext.getCacheDir() + File.separator + "crash");
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    private File getCrashCacheFile() {
        return new File(this.getCrashCacheDir(), String.format("%s.log", this.mFilenamePrefix));
    }

    private File getCrashCacheScreenshotFile(int num) {
        return new File(this.getCrashCacheDir(), String.format("%s_%d.png", this.mFilenamePrefix, num));
    }

    public void clearCacheHistory() {
        DoKitFileUtil.deleteDirectory(this.getCrashCacheDir());
    }

    private void generateFilenamePrefix() {
        this.mFilenamePrefix = this.mDateFormat.format(System.currentTimeMillis());
    }

    public void asyncSaveCrashScreenshot() {
        this.saveCrashScreenshot();
    }

    public void saveCrashScreenshot() {
        try {
            Class<?> wmgClass = Class.forName("android.view.WindowManagerGlobal");
            Object wmgInstance = wmgClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Method getViewRootNames = wmgClass.getMethod("getViewRootNames", new Class[0]);
            Method getRootView = wmgClass.getMethod("getRootView", String.class);
            String[] rootViewNames = (String[])getViewRootNames.invoke(wmgInstance, new Object[0]);
            if (rootViewNames != null) {
                for (int i = 0; i < rootViewNames.length; ++i) {
                    View rootView = (View)getRootView.invoke(wmgInstance, rootViewNames[i]);
                    if (rootView == null) continue;
                    if (!ViewCompat.isLaidOut((View)rootView)) {
                        Log.d((String)TAG, (String)"View\u5c1a\u672a\u7ed8\u5236\u5b8c\u6210\uff0c\u53ef\u80fd\u65e0\u6cd5\u6210\u529f\u622a\u53d6\u56fe\u7247");
                    }
                    Bitmap bitmap = Bitmap.createBitmap((int)rootView.getWidth(), (int)rootView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas canvas = new Canvas(bitmap);
                    rootView.draw(canvas);
                    File output = this.getCrashCacheScreenshotFile(i);
                    DoKitImageUtil.bitmap2File(bitmap, 100, output);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Holder {
        private static final CrashCaptureManager INSTANCE = new CrashCaptureManager();

        private Holder() {
        }
    }
}

