/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.colorpick;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.RoundedBitmapDrawable;
import androidx.core.graphics.drawable.RoundedBitmapDrawableFactory;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.util.ColorUtil;

public class ColorPickerView
extends View {
    private Paint mRingPaint;
    private Paint mBitmapPaint;
    private Paint mFocusPaint;
    private Paint mGridPaint;
    private Paint mGridShadowPaint;
    private TextPaint mTextPaint;
    private Path mClipPath = new Path();
    private Matrix mBitmapMatrix = new Matrix();
    private Rect mGridRect = new Rect();
    private Bitmap mCircleBitmap;
    private String mText;
    private RoundedBitmapDrawable mGridDrawable;

    public ColorPickerView(Context context) {
        super(context);
        this.init();
    }

    public ColorPickerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ColorPickerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mRingPaint = new Paint();
        this.mRingPaint.setAntiAlias(true);
        this.mRingPaint.setColor(-1);
        this.mRingPaint.setStyle(Paint.Style.STROKE);
        this.mFocusPaint = new Paint();
        this.mFocusPaint.setAntiAlias(true);
        this.mFocusPaint.setStyle(Paint.Style.STROKE);
        this.mFocusPaint.setStrokeWidth(3.0f);
        this.mFocusPaint.setColor(-16777216);
        this.mBitmapPaint = new Paint();
        this.mBitmapPaint.setFilterBitmap(false);
        this.mGridPaint = new Paint();
        this.mGridPaint.setStrokeWidth(1.0f);
        this.mGridPaint.setStyle(Paint.Style.STROKE);
        this.mGridPaint.setColor(-3355444);
        this.mGridShadowPaint = new Paint(this.mGridPaint);
        this.mGridShadowPaint.setColor(-12303292);
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextPaint.setTypeface(Typeface.MONOSPACE);
        this.mTextPaint.setTextSize((float)this.getResources().getDimensionPixelSize(R.dimen.dk_font_size_12));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mClipPath.rewind();
        this.mClipPath.moveTo(0.0f, 0.0f);
        this.mClipPath.addCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)(this.getWidth() / 2), Path.Direction.CW);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBitmap(canvas);
        this.drawGrid(canvas);
        this.drawRing(canvas);
        this.drawText(canvas);
        this.drawFocus(canvas);
    }

    private void drawText(Canvas canvas) {
        if (!TextUtils.isEmpty((CharSequence)this.mText)) {
            float ringWidth = 36.0f;
            float hOffset = (float)((double)this.getWidth() * Math.PI * 0.25);
            float vOffset = ringWidth - 5.0f;
            canvas.drawTextOnPath(this.mText, this.mClipPath, hOffset, vOffset, (Paint)this.mTextPaint);
            canvas.setDrawFilter(null);
        }
    }

    private void drawGrid(Canvas canvas) {
        if (this.mGridDrawable == null) {
            Bitmap gridBitmap = this.createGridBitmap(16, canvas);
            this.mGridDrawable = RoundedBitmapDrawableFactory.create((Resources)this.getResources(), (Bitmap)gridBitmap);
            this.mGridDrawable.setBounds(0, 0, this.getRight(), this.getBottom());
            this.mGridDrawable.setCircular(true);
        }
        this.mGridDrawable.draw(canvas);
    }

    private Bitmap createGridBitmap(int pixInterval, Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        canvas.getClipBounds(this.mGridRect);
        Bitmap gridBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas gridCanvas = new Canvas(gridBitmap);
        if (pixInterval >= 4) {
            float end;
            float start;
            float value;
            int i;
            int alpha = Math.min(pixInterval * 36, 255);
            this.mGridPaint.setAlpha(alpha);
            this.mGridShadowPaint.setAlpha(alpha);
            gridCanvas.save();
            for (i = 0; i <= this.getWidth(); i += pixInterval) {
                value = i - 1;
                start = 0.0f;
                end = height;
                gridCanvas.drawLine(value, start, value, end, this.mGridPaint);
                value = i;
                gridCanvas.drawLine(value, start, value, end, this.mGridShadowPaint);
            }
            for (i = 0; i <= this.getHeight(); i += pixInterval) {
                value = i - 1;
                start = 0.0f;
                end = width;
                gridCanvas.drawLine(start, value, end, value, this.mGridPaint);
                value = i;
                gridCanvas.drawLine(start, value, end, value, this.mGridShadowPaint);
            }
            gridCanvas.restore();
        }
        return gridBitmap;
    }

    private void drawFocus(Canvas canvas) {
        float focusWidth = 20.0f;
        canvas.drawRect((float)(this.getWidth() / 2 - 2), (float)(this.getWidth() / 2 - 2), (float)(this.getWidth() / 2) + focusWidth - 2.0f, (float)(this.getWidth() / 2) + focusWidth - 2.0f, this.mFocusPaint);
    }

    private void drawRing(Canvas canvas) {
        canvas.setDrawFilter((DrawFilter)new PaintFlagsDrawFilter(0, 3));
        float ringWidth = 36.0f;
        this.mRingPaint.setStrokeWidth(ringWidth);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), (float)(this.getWidth() / 2) - ringWidth / 2.0f, this.mRingPaint);
        this.mRingPaint.setColor(this.getResources().getColor(R.color.dk_color_333333));
        this.mRingPaint.setStrokeWidth(0.5f);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), (float)(this.getWidth() / 2), this.mRingPaint);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), (float)(this.getWidth() / 2) - ringWidth, this.mRingPaint);
    }

    private void drawBitmap(Canvas canvas) {
        if (this.mCircleBitmap == null || this.mCircleBitmap.isRecycled()) {
            return;
        }
        canvas.save();
        canvas.clipPath(this.mClipPath);
        this.mBitmapMatrix.reset();
        this.mBitmapMatrix.postScale((float)this.getWidth() / (float)this.mCircleBitmap.getWidth(), (float)this.getHeight() / (float)this.mCircleBitmap.getHeight());
        canvas.drawBitmap(this.mCircleBitmap, this.mBitmapMatrix, this.mBitmapPaint);
        canvas.restore();
    }

    public void setBitmap(Bitmap bitmap, int color2, int x, int y) {
        this.mCircleBitmap = bitmap;
        this.mText = String.format("%s   %d,%d", ColorUtil.parseColorInt(color2), x + 16, y + 16);
        this.mRingPaint.setColor(color2);
        if (ColorUtil.isColdColor(color2)) {
            this.mFocusPaint.setColor(-1);
            this.mTextPaint.setColor(-1);
        } else {
            this.mFocusPaint.setColor(-16777216);
            this.mTextPaint.setColor(-16777216);
        }
        this.invalidate();
    }
}

