/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.blockmonitor.bean;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;

public class BlockInfo {
    public static final String SEPARATOR = "\r\n";
    private static final String KV = " = ";
    private static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.CHINESE);
    public static final String NEW_INSTANCE_METHOD = "newInstance: ";
    private static final String KEY_TIME_COST = "time";
    private static final String KEY_THREAD_TIME_COST = "thread-time";
    private static final String KEY_TIME_COST_START = "time-start";
    private static final String KEY_TIME_COST_END = "time-end";
    private static final String KEY_STACK = "stack";
    public long timeCost;
    private long threadTimeCost;
    public long time;
    public String timeStart;
    private String timeEnd;
    public ArrayList<String> threadStackEntries = new ArrayList();
    private StringBuilder timeSb = new StringBuilder();
    private StringBuilder stackSb = new StringBuilder();
    public String concernStackString;

    public static BlockInfo newInstance() {
        BlockInfo blockInfo = new BlockInfo();
        return blockInfo;
    }

    public BlockInfo flushString() {
        String separator = SEPARATOR;
        this.timeSb.append(KEY_TIME_COST).append(KV).append(this.timeCost).append(separator);
        this.timeSb.append(KEY_THREAD_TIME_COST).append(KV).append(this.threadTimeCost).append(separator);
        this.timeSb.append(KEY_TIME_COST_START).append(KV).append(this.timeStart).append(separator);
        this.timeSb.append(KEY_TIME_COST_END).append(KV).append(this.timeEnd).append(separator);
        if (this.threadStackEntries != null && !this.threadStackEntries.isEmpty()) {
            StringBuilder temp = new StringBuilder();
            for (String s : this.threadStackEntries) {
                temp.append(s);
                temp.append(separator);
            }
            this.stackSb.append(KEY_STACK).append(KV).append(temp.toString()).append(separator);
        }
        return this;
    }

    public BlockInfo setThreadStackEntries(ArrayList<String> threadStackEntries) {
        this.threadStackEntries = threadStackEntries;
        return this;
    }

    public BlockInfo setMainThreadTimeCost(long realTimeStart, long realTimeEnd, long threadTimeStart, long threadTimeEnd) {
        this.timeCost = realTimeEnd - realTimeStart;
        this.threadTimeCost = threadTimeEnd - threadTimeStart;
        this.timeStart = TIME_FORMATTER.format(realTimeStart);
        this.timeEnd = TIME_FORMATTER.format(realTimeEnd);
        return this;
    }

    public String toString() {
        return this.timeSb.toString() + "\n" + this.stackSb.toString();
    }
}

