/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.alignruler;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.util.UIUtils;

public class AlignLineView
extends View {
    private Paint mTextPaint;
    private Paint mLinePaint;
    private int mPosX = -1;
    private int mPosY = -1;
    private boolean mIncludeStatusBarHeight;

    public AlignLineView(Context context) {
        super(context);
        this.init();
    }

    public AlignLineView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AlignLineView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mLinePaint = new Paint();
        this.mLinePaint.setAntiAlias(true);
        this.mLinePaint.setColor(this.getResources().getColor(R.color.dk_color_CC3A4B));
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize((float)this.getResources().getDimensionPixelSize(R.dimen.dk_font_size_14));
        this.mTextPaint.setColor(this.getResources().getColor(R.color.dk_color_333333));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawLine(canvas);
        this.drawText(canvas);
    }

    private void drawText(Canvas canvas) {
        if (this.mPosY == -1 && this.mPosX == -1) {
            return;
        }
        int left = this.mPosX;
        int right = this.getWidth() - this.mPosX;
        int top = this.mPosY;
        int bottom = this.getHeight() - this.mPosY;
        canvas.drawText(String.valueOf(left), (float)(left / 2), (float)this.mPosY, this.mTextPaint);
        canvas.drawText(String.valueOf(right), (float)((this.mPosX + this.getWidth()) / 2), (float)this.mPosY, this.mTextPaint);
        canvas.drawText(String.valueOf(top + (this.mIncludeStatusBarHeight ? UIUtils.getStatusBarHeight() : 0)), (float)this.mPosX, (float)(top / 2), this.mTextPaint);
        canvas.drawText(String.valueOf(bottom), (float)this.mPosX, (float)((this.mPosY + this.getHeight()) / 2), this.mTextPaint);
    }

    private void drawLine(Canvas canvas) {
        if (this.mPosY == -1 && this.mPosX == -1) {
            return;
        }
        canvas.drawLine(0.0f, (float)this.mPosY, (float)this.getWidth(), (float)this.mPosY, this.mLinePaint);
        canvas.drawLine((float)this.mPosX, 0.0f, (float)this.mPosX, (float)this.getHeight(), this.mLinePaint);
    }

    public void showInfo(int x, int y) {
        this.mPosX = x;
        this.mPosY = y;
        this.invalidate();
    }

    public void refreshInfo(boolean includeStatusBarHeight) {
        this.mIncludeStatusBarHeight = includeStatusBarHeight;
        this.invalidate();
    }
}

