/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.aop.bigimg.glide;

import android.content.Context;
import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.didichuxing.doraemonkit.config.PerformanceSpInfoConfig;
import com.didichuxing.doraemonkit.kit.largepicture.LargePictureManager;
import com.didichuxing.doraemonkit.util.ConvertUtils;
import com.didichuxing.doraemonkit.util.ReflectUtils;
import java.security.MessageDigest;

public class DokitGlideTransform
implements Transformation<Bitmap> {
    private static final String ID = "com.didichuxing.doraemonkit.aop.bigimg.glide.DokitGlideTransform";
    private static final byte[] ID_BYTES = "com.didichuxing.doraemonkit.aop.bigimg.glide.DokitGlideTransform".getBytes(CHARSET);
    private static final String TAG = "DokitGlideTransform";
    private Object mRequestBuilder;
    private Transformation mWrap;

    public DokitGlideTransform(Object mRequestBuilder, Object transformation) {
        this.mRequestBuilder = mRequestBuilder;
        if (transformation instanceof Transformation) {
            this.mWrap = (Transformation)transformation;
        }
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        if (this.mWrap != null) {
            this.mWrap.updateDiskCacheKey(messageDigest);
        } else {
            messageDigest.update(ID_BYTES);
        }
    }

    public boolean equals(Object o) {
        if (this.mWrap != null) {
            return this.mWrap.equals(o);
        }
        return false;
    }

    public int hashCode() {
        if (this.mWrap != null) {
            return this.mWrap.hashCode();
        }
        return 0;
    }

    @NonNull
    public Resource<Bitmap> transform(@NonNull Context context, @NonNull Resource<Bitmap> resource, int outWidth, int outHeight) {
        block8: {
            try {
                if (this.mWrap != null) {
                    resource = this.mWrap.transform(context, resource, outWidth, outHeight);
                }
                if (PerformanceSpInfoConfig.isLargeImgOpen()) {
                    String url = "";
                    if (this.mRequestBuilder instanceof RequestBuilder) {
                        if (ReflectUtils.reflect((Object)this.mRequestBuilder).field("model").get() instanceof String) {
                            url = (String)ReflectUtils.reflect((Object)this.mRequestBuilder).field("model").get();
                        } else if (ReflectUtils.reflect((Object)this.mRequestBuilder).field("model").get() instanceof Integer) {
                            url = "" + ReflectUtils.reflect((Object)this.mRequestBuilder).field("model").get();
                        }
                    }
                    Bitmap bitmap = (Bitmap)resource.get();
                    double imgSize = ConvertUtils.byte2MemorySize((long)bitmap.getByteCount(), (int)0x100000);
                    LargePictureManager.getInstance().saveImageInfo(url, imgSize, bitmap.getWidth(), bitmap.getHeight(), "Glide");
                }
            }
            catch (Exception e) {
                if (this.mWrap == null) break block8;
                resource = this.mWrap.transform(context, resource, outWidth, outHeight);
            }
        }
        return resource;
    }
}

