/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.content.res.Resources;
import androidx.annotation.ArrayRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.didichuxing.doraemonkit.util.Utils;
import java.util.IllegalFormatException;

public final class StringUtils {
    private StringUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean isTrimEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(CharSequence s1, CharSequence s2) {
        int length;
        if (s1 == s2) {
            return true;
        }
        if (s1 != null && s2 != null && (length = s1.length()) == s2.length()) {
            if (s1 instanceof String && s2 instanceof String) {
                return s1.equals(s2);
            }
            for (int i = 0; i < length; ++i) {
                if (s1.charAt(i) == s2.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equalsIgnoreCase(s2);
    }

    public static String null2Length0(String s) {
        return s == null ? "" : s;
    }

    public static int length(CharSequence s) {
        return s == null ? 0 : s.length();
    }

    public static String upperFirstLetter(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        if (!Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return (char)(s.charAt(0) - 32) + s.substring(1);
    }

    public static String lowerFirstLetter(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        if (!Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return String.valueOf((char)(s.charAt(0) + 32)) + s.substring(1);
    }

    public static String reverse(String s) {
        if (s == null) {
            return "";
        }
        int len = s.length();
        if (len <= 1) {
            return s;
        }
        int mid = len >> 1;
        char[] chars = s.toCharArray();
        for (int i = 0; i < mid; ++i) {
            char c = chars[i];
            chars[i] = chars[len - i - 1];
            chars[len - i - 1] = c;
        }
        return new String(chars);
    }

    public static String toDBC(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char[] chars = s.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            chars[i] = chars[i] == '\u3000' ? 32 : ('\uff01' <= chars[i] && chars[i] <= '\uff5e' ? (char)(chars[i] - 65248) : chars[i]);
        }
        return new String(chars);
    }

    public static String toSBC(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char[] chars = s.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            chars[i] = chars[i] == ' ' ? 12288 : ('!' <= chars[i] && chars[i] <= '~' ? (char)(chars[i] + 65248) : chars[i]);
        }
        return new String(chars);
    }

    public static String getString(@StringRes int id2) {
        return StringUtils.getString(id2, null);
    }

    public static String getString(@StringRes int id2, Object ... formatArgs) {
        try {
            return StringUtils.format(Utils.getApp().getString(id2), formatArgs);
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
            return String.valueOf(id2);
        }
    }

    public static String[] getStringArray(@ArrayRes int id2) {
        try {
            return Utils.getApp().getResources().getStringArray(id2);
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
            return new String[]{String.valueOf(id2)};
        }
    }

    public static String format(@Nullable String str, Object ... args) {
        String text = str;
        if (text != null && args != null && args.length > 0) {
            try {
                text = String.format(str, args);
            }
            catch (IllegalFormatException e) {
                e.printStackTrace();
            }
        }
        return text;
    }
}

