/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.util.NotificationUtils;
import com.didichuxing.doraemonkit.util.Utils;
import com.didichuxing.doraemonkit.util.UtilsBridge;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MessengerUtils {
    private static ConcurrentHashMap<String, MessageCallback> subscribers = new ConcurrentHashMap();
    private static Map<String, Client> sClientMap = new HashMap<String, Client>();
    private static Client sLocalClient;
    private static final int WHAT_SUBSCRIBE = 0;
    private static final int WHAT_UNSUBSCRIBE = 1;
    private static final int WHAT_SEND = 2;
    private static final String KEY_STRING = "MESSENGER_UTILS";

    public static void register() {
        if (UtilsBridge.isMainProcess()) {
            if (UtilsBridge.isServiceRunning(ServerService.class.getName())) {
                Log.i((String)"MessengerUtils", (String)"Server service is running.");
                return;
            }
            MessengerUtils.startServiceCompat(new Intent((Context)Utils.getApp(), ServerService.class));
            return;
        }
        if (sLocalClient == null) {
            Client client = new Client(null);
            if (client.bind()) {
                sLocalClient = client;
            } else {
                Log.e((String)"MessengerUtils", (String)"Bind service failed.");
            }
        } else {
            Log.i((String)"MessengerUtils", (String)"The client have been bind.");
        }
    }

    public static void unregister() {
        if (UtilsBridge.isMainProcess()) {
            if (!UtilsBridge.isServiceRunning(ServerService.class.getName())) {
                Log.i((String)"MessengerUtils", (String)"Server service isn't running.");
                return;
            }
            Intent intent = new Intent((Context)Utils.getApp(), ServerService.class);
            Utils.getApp().stopService(intent);
        }
        if (sLocalClient != null) {
            sLocalClient.unbind();
        }
    }

    public static void register(String pkgName) {
        if (sClientMap.containsKey(pkgName)) {
            Log.i((String)"MessengerUtils", (String)("register: client registered: " + pkgName));
            return;
        }
        Client client = new Client(pkgName);
        if (client.bind()) {
            sClientMap.put(pkgName, client);
        } else {
            Log.e((String)"MessengerUtils", (String)("register: client bind failed: " + pkgName));
        }
    }

    public static void unregister(String pkgName) {
        if (!sClientMap.containsKey(pkgName)) {
            Log.i((String)"MessengerUtils", (String)("unregister: client didn't register: " + pkgName));
            return;
        }
        Client client = sClientMap.get(pkgName);
        sClientMap.remove(pkgName);
        if (client != null) {
            client.unbind();
        }
    }

    public static void subscribe(@NonNull String key, @NonNull MessageCallback callback) {
        subscribers.put(key, callback);
    }

    public static void unsubscribe(@NonNull String key) {
        subscribers.remove(key);
    }

    public static void post(@NonNull String key, @NonNull Bundle data) {
        data.putString(KEY_STRING, key);
        if (sLocalClient != null) {
            sLocalClient.sendMsg2Server(data);
        } else {
            Intent intent = new Intent((Context)Utils.getApp(), ServerService.class);
            intent.putExtras(data);
            MessengerUtils.startServiceCompat(intent);
        }
        for (Client client : sClientMap.values()) {
            client.sendMsg2Server(data);
        }
    }

    private static void startServiceCompat(Intent intent) {
        try {
            intent.setFlags(32);
            if (Build.VERSION.SDK_INT >= 26) {
                Utils.getApp().startForegroundService(intent);
            } else {
                Utils.getApp().startService(intent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface MessageCallback {
        public void messageCall(Bundle var1);
    }

    public static class ServerService
    extends Service {
        private final ConcurrentHashMap<Integer, Messenger> mClientMap = new ConcurrentHashMap();
        @SuppressLint(value={"HandlerLeak"})
        private final Handler mReceiveClientMsgHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        mClientMap.put(msg.arg1, msg.replyTo);
                        break;
                    }
                    case 2: {
                        this.sendMsg2Client(msg);
                        this.consumeServerProcessCallback(msg);
                        break;
                    }
                    case 1: {
                        mClientMap.remove(msg.arg1);
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        };
        private final Messenger messenger = new Messenger(this.mReceiveClientMsgHandler);

        @Nullable
        public IBinder onBind(Intent intent) {
            return this.messenger.getBinder();
        }

        public int onStartCommand(Intent intent, int flags, int startId) {
            Bundle extras;
            if (Build.VERSION.SDK_INT >= 26) {
                Notification notification = UtilsBridge.getNotification(NotificationUtils.ChannelConfig.DEFAULT_CHANNEL_CONFIG, null);
                this.startForeground(1, notification);
            }
            if (intent != null && (extras = intent.getExtras()) != null) {
                Message msg = Message.obtain((Handler)this.mReceiveClientMsgHandler, (int)2);
                msg.replyTo = this.messenger;
                msg.setData(extras);
                this.sendMsg2Client(msg);
                this.consumeServerProcessCallback(msg);
            }
            return 2;
        }

        private void sendMsg2Client(Message msg) {
            for (Messenger client : this.mClientMap.values()) {
                try {
                    if (client == null) continue;
                    client.send(msg);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }

        private void consumeServerProcessCallback(Message msg) {
            MessageCallback callback;
            String key;
            Bundle data = msg.getData();
            if (data != null && (key = data.getString(MessengerUtils.KEY_STRING)) != null && (callback = (MessageCallback)subscribers.get(key)) != null) {
                callback.messageCall(data);
            }
        }
    }

    static class Client {
        String mPkgName;
        Messenger mServer;
        LinkedList<Bundle> mCached = new LinkedList();
        @SuppressLint(value={"HandlerLeak"})
        Handler mReceiveServeMsgHandler = new Handler(){

            public void handleMessage(Message msg) {
                MessageCallback callback;
                Bundle data = msg.getData();
                data.setClassLoader(MessengerUtils.class.getClassLoader());
                String key = data.getString(MessengerUtils.KEY_STRING);
                if (key != null && (callback = (MessageCallback)subscribers.get(key)) != null) {
                    callback.messageCall(data);
                }
            }
        };
        Messenger mClient = new Messenger(this.mReceiveServeMsgHandler);
        ServiceConnection mConn = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                Log.d((String)"MessengerUtils", (String)("client service connected " + name));
                mServer = new Messenger(service);
                int key = UtilsBridge.getCurrentProcessName().hashCode();
                Message msg = Message.obtain((Handler)mReceiveServeMsgHandler, (int)0, (int)key, (int)0);
                msg.getData().setClassLoader(MessengerUtils.class.getClassLoader());
                msg.replyTo = mClient;
                try {
                    mServer.send(msg);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                this.sendCachedMsg2Server();
            }

            public void onServiceDisconnected(ComponentName name) {
                Log.w((String)"MessengerUtils", (String)("client service disconnected:" + name));
                mServer = null;
                if (!this.bind()) {
                    Log.e((String)"MessengerUtils", (String)("client service rebind failed: " + name));
                }
            }
        };

        Client(String pkgName) {
            this.mPkgName = pkgName;
        }

        boolean bind() {
            if (TextUtils.isEmpty((CharSequence)this.mPkgName)) {
                Intent intent = new Intent((Context)Utils.getApp(), ServerService.class);
                return Utils.getApp().bindService(intent, this.mConn, 1);
            }
            if (UtilsBridge.isAppInstalled(this.mPkgName)) {
                if (UtilsBridge.isAppRunning(this.mPkgName)) {
                    Intent intent = new Intent(this.mPkgName + ".messenger");
                    intent.setPackage(this.mPkgName);
                    return Utils.getApp().bindService(intent, this.mConn, 1);
                }
                Log.e((String)"MessengerUtils", (String)("bind: the app is not running -> " + this.mPkgName));
                return false;
            }
            Log.e((String)"MessengerUtils", (String)("bind: the app is not installed -> " + this.mPkgName));
            return false;
        }

        void unbind() {
            int key = UtilsBridge.getCurrentProcessName().hashCode();
            Message msg = Message.obtain((Handler)this.mReceiveServeMsgHandler, (int)1, (int)key, (int)0);
            msg.replyTo = this.mClient;
            try {
                this.mServer.send(msg);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            try {
                Utils.getApp().unbindService(this.mConn);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void sendMsg2Server(Bundle bundle) {
            if (this.mServer == null) {
                this.mCached.addFirst(bundle);
                Log.i((String)"MessengerUtils", (String)("save the bundle " + bundle));
            } else {
                this.sendCachedMsg2Server();
                if (!this.send2Server(bundle)) {
                    this.mCached.addFirst(bundle);
                }
            }
        }

        private void sendCachedMsg2Server() {
            if (this.mCached.isEmpty()) {
                return;
            }
            for (int i = this.mCached.size() - 1; i >= 0; --i) {
                if (!this.send2Server(this.mCached.get(i))) continue;
                this.mCached.remove(i);
            }
        }

        private boolean send2Server(Bundle bundle) {
            Message msg = Message.obtain((Handler)this.mReceiveServeMsgHandler, (int)2);
            bundle.setClassLoader(MessengerUtils.class.getClassLoader());
            msg.setData(bundle);
            msg.replyTo = this.mClient;
            try {
                this.mServer.send(msg);
                return true;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

