/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class GsonUtils {
    private static final String KEY_DEFAULT = "defaultGson";
    private static final String KEY_DELEGATE = "delegateGson";
    private static final String KEY_LOG_UTILS = "logUtilsGson";
    private static final Map<String, Gson> GSONS = new ConcurrentHashMap<String, Gson>();

    private GsonUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void setGsonDelegate(Gson delegate) {
        if (delegate == null) {
            return;
        }
        GSONS.put(KEY_DELEGATE, delegate);
    }

    public static void setGson(String key, Gson gson) {
        if (TextUtils.isEmpty((CharSequence)key) || gson == null) {
            return;
        }
        GSONS.put(key, gson);
    }

    public static Gson getGson(String key) {
        return GSONS.get(key);
    }

    public static Gson getGson() {
        Gson gsonDelegate = GSONS.get(KEY_DELEGATE);
        if (gsonDelegate != null) {
            return gsonDelegate;
        }
        Gson gsonDefault = GSONS.get(KEY_DEFAULT);
        if (gsonDefault == null) {
            gsonDefault = GsonUtils.createGson();
            GSONS.put(KEY_DEFAULT, gsonDefault);
        }
        return gsonDefault;
    }

    public static String toJson(Object object) {
        return GsonUtils.toJson(GsonUtils.getGson(), object);
    }

    public static String toJson(Object src, @NonNull Type typeOfSrc) {
        return GsonUtils.toJson(GsonUtils.getGson(), src, typeOfSrc);
    }

    public static String toJson(@NonNull Gson gson, Object object) {
        return gson.toJson(object);
    }

    public static String toJson(@NonNull Gson gson, Object src, @NonNull Type typeOfSrc) {
        return gson.toJson(src, typeOfSrc);
    }

    public static <T> T fromJson(String json, @NonNull Class<T> type) {
        return GsonUtils.fromJson(GsonUtils.getGson(), json, type);
    }

    public static <T> T fromJson(String json, @NonNull Type type) {
        return GsonUtils.fromJson(GsonUtils.getGson(), json, type);
    }

    public static <T> T fromJson(@NonNull Reader reader, @NonNull Class<T> type) {
        return GsonUtils.fromJson(GsonUtils.getGson(), reader, type);
    }

    public static <T> T fromJson(@NonNull Reader reader, @NonNull Type type) {
        return GsonUtils.fromJson(GsonUtils.getGson(), reader, type);
    }

    public static <T> T fromJson(@NonNull Gson gson, String json, @NonNull Class<T> type) {
        return (T)gson.fromJson(json, type);
    }

    public static <T> T fromJson(@NonNull Gson gson, String json, @NonNull Type type) {
        return (T)gson.fromJson(json, type);
    }

    public static <T> T fromJson(@NonNull Gson gson, Reader reader, @NonNull Class<T> type) {
        return (T)gson.fromJson(reader, type);
    }

    public static <T> T fromJson(@NonNull Gson gson, Reader reader, @NonNull Type type) {
        return (T)gson.fromJson(reader, type);
    }

    public static Type getListType(@NonNull Type type) {
        return TypeToken.getParameterized(List.class, (Type[])new Type[]{type}).getType();
    }

    public static Type getSetType(@NonNull Type type) {
        return TypeToken.getParameterized(Set.class, (Type[])new Type[]{type}).getType();
    }

    public static Type getMapType(@NonNull Type keyType, @NonNull Type valueType) {
        return TypeToken.getParameterized(Map.class, (Type[])new Type[]{keyType, valueType}).getType();
    }

    public static Type getArrayType(@NonNull Type type) {
        return TypeToken.getArray((Type)type).getType();
    }

    public static Type getType(@NonNull Type rawType, Type ... typeArguments) {
        return TypeToken.getParameterized((Type)rawType, (Type[])typeArguments).getType();
    }

    static Gson getGson4LogUtils() {
        Gson gson4LogUtils = GSONS.get(KEY_LOG_UTILS);
        if (gson4LogUtils == null) {
            gson4LogUtils = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
            GSONS.put(KEY_LOG_UTILS, gson4LogUtils);
        }
        return gson4LogUtils;
    }

    private static Gson createGson() {
        return new GsonBuilder().serializeNulls().disableHtmlEscaping().create();
    }
}

