/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PowerManager;
import androidx.annotation.RequiresApi;
import com.didichuxing.doraemonkit.util.ThreadUtils;
import com.didichuxing.doraemonkit.util.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.Set;

public final class BatteryUtils {
    @RequiresApi(api=23)
    public static boolean isIgnoringBatteryOptimizations() {
        return BatteryUtils.isIgnoringBatteryOptimizations(Utils.getApp().getPackageName());
    }

    @RequiresApi(api=23)
    public static boolean isIgnoringBatteryOptimizations(String pkgName) {
        try {
            PowerManager pm = (PowerManager)Utils.getApp().getSystemService("power");
            return pm.isIgnoringBatteryOptimizations(pkgName);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void registerBatteryStatusChangedListener(OnBatteryStatusChangedListener listener) {
        BatteryChangedReceiver.getInstance().registerListener(listener);
    }

    public static boolean isRegistered(OnBatteryStatusChangedListener listener) {
        return BatteryChangedReceiver.getInstance().isRegistered(listener);
    }

    public static void unregisterBatteryStatusChangedListener(OnBatteryStatusChangedListener listener) {
        BatteryChangedReceiver.getInstance().unregisterListener(listener);
    }

    public static final class Status {
        private int level;
        private int status;

        Status(int level, int status) {
            this.level = level;
            this.status = status;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String toString() {
            return Status.batteryStatus2String(this.status) + ": " + this.level + "%";
        }

        public static String batteryStatus2String(int status) {
            if (status == 3) {
                return "discharging";
            }
            if (status == 2) {
                return "charging";
            }
            if (status == 4) {
                return "not_charging";
            }
            if (status == 5) {
                return "full";
            }
            return "unknown";
        }
    }

    public static interface OnBatteryStatusChangedListener {
        public void onBatteryStatusChanged(Status var1);
    }

    public static final class BatteryChangedReceiver
    extends BroadcastReceiver {
        private Set<OnBatteryStatusChangedListener> mListeners = new HashSet<OnBatteryStatusChangedListener>();

        private static BatteryChangedReceiver getInstance() {
            return LazyHolder.INSTANCE;
        }

        void registerListener(final OnBatteryStatusChangedListener listener) {
            if (listener == null) {
                return;
            }
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    int preSize = mListeners.size();
                    mListeners.add(listener);
                    if (preSize == 0 && mListeners.size() == 1) {
                        IntentFilter intentFilter = new IntentFilter();
                        intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
                        Utils.getApp().registerReceiver((BroadcastReceiver)BatteryChangedReceiver.getInstance(), intentFilter);
                    }
                }
            });
        }

        boolean isRegistered(OnBatteryStatusChangedListener listener) {
            if (listener == null) {
                return false;
            }
            return this.mListeners.contains(listener);
        }

        void unregisterListener(final OnBatteryStatusChangedListener listener) {
            if (listener == null) {
                return;
            }
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    int preSize = mListeners.size();
                    mListeners.remove(listener);
                    if (preSize == 1 && mListeners.size() == 0) {
                        Utils.getApp().unregisterReceiver((BroadcastReceiver)BatteryChangedReceiver.getInstance());
                    }
                }
            });
        }

        public void onReceive(Context context, final Intent intent) {
            if ("android.intent.action.BATTERY_CHANGED".equals(intent.getAction())) {
                ThreadUtils.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        int level = intent.getIntExtra("level", -1);
                        int status = intent.getIntExtra("status", 1);
                        for (OnBatteryStatusChangedListener listener : mListeners) {
                            listener.onBatteryStatusChanged(new Status(level, status));
                        }
                    }
                });
            }
        }

        private static class LazyHolder {
            private static final BatteryChangedReceiver INSTANCE = new BatteryChangedReceiver();

            private LazyHolder() {
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BatteryStatus {
        public static final int UNKNOWN = 1;
        public static final int DISCHARGING = 3;
        public static final int CHARGING = 2;
        public static final int NOT_CHARGING = 4;
        public static final int FULL = 5;
    }
}

